/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.datasource;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.store.jdbc.datasource.DataSourceProvider;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;

public class H2DataSourceProvider
implements DataSourceProvider {
    private static final ConcurrentHashMap<String, DataSource> DATA_SOURCE_MAP = new ConcurrentHashMap();
    private static final Object lock = new Object();
    private static final String URL_KEY = "jdbc.url";
    private static final String USERNAME_KEY = "jdbc.username";
    private static final String PASSWORD_KEY = "jdbc.password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource(Config config) {
        String url = config.getParameter(URL_KEY);
        String username = config.getParameter(USERNAME_KEY);
        String password = config.getParameter(PASSWORD_KEY);
        String cachedKey = StringUtils.concat(url, username, password);
        DataSource dataSource = DATA_SOURCE_MAP.get(cachedKey);
        if (dataSource == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    dataSource = DATA_SOURCE_MAP.get(cachedKey);
                    if (dataSource != null) {
                        return dataSource;
                    }
                    dataSource = this.createDataSource(config);
                    DATA_SOURCE_MAP.put(cachedKey, dataSource);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(StringUtils.format("connect datasource failed! url: {}", url), e);
            }
        }
        return dataSource;
    }

    private DataSource createDataSource(Config config) throws ClassNotFoundException {
        String url = config.getParameter(URL_KEY);
        String username = config.getParameter(USERNAME_KEY);
        String password = config.getParameter(PASSWORD_KEY);
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setUrl(url);
        dataSource.setUser(username);
        dataSource.setPassword(password);
        return dataSource;
    }
}

