/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.SqlTemplateImpl;
import com.github.ltsopensource.store.jdbc.datasource.DataSourceProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;

public class SqlTemplateFactory {
    private static final ConcurrentMap<DataSource, SqlTemplate> HOLDER = new ConcurrentHashMap<DataSource, SqlTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlTemplate create(Config config) {
        DataSourceProvider dataSourceProvider = ServiceLoader.load(DataSourceProvider.class, config);
        DataSource dataSource = dataSourceProvider.getDataSource(config);
        SqlTemplate sqlTemplate = (SqlTemplate)HOLDER.get(dataSource);
        if (sqlTemplate != null) {
            return sqlTemplate;
        }
        ConcurrentMap<DataSource, SqlTemplate> concurrentMap = HOLDER;
        synchronized (concurrentMap) {
            sqlTemplate = (SqlTemplate)HOLDER.get(dataSource);
            if (sqlTemplate != null) {
                return sqlTemplate;
            }
            sqlTemplate = new SqlTemplateImpl(dataSource);
            HOLDER.putIfAbsent(dataSource, sqlTemplate);
            return sqlTemplate;
        }
    }
}

