/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.netty;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.remoting.AbstractRemotingServer;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.RemotingEvent;
import com.github.ltsopensource.remoting.RemotingEventType;
import com.github.ltsopensource.remoting.RemotingServerConfig;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.netty.NettyChannel;
import com.github.ltsopensource.remoting.netty.NettyCodecFactory;
import com.github.ltsopensource.remoting.netty.NettyLogger;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class NettyRemotingServer
extends AbstractRemotingServer {
    public static final Logger LOGGER = AbstractRemotingServer.LOGGER;
    private final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final EventLoopGroup bossSelectorGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("NettyBossSelectorThread_"));
    private final EventLoopGroup workerSelectorGroup;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private AppContext appContext;

    public NettyRemotingServer(AppContext appContext, RemotingServerConfig remotingServerConfig) {
        this(remotingServerConfig, null);
        this.appContext = appContext;
    }

    public NettyRemotingServer(RemotingServerConfig remotingServerConfig, ChannelEventListener channelEventListener) {
        super(remotingServerConfig, channelEventListener);
        this.workerSelectorGroup = new NioEventLoopGroup(remotingServerConfig.getServerSelectorThreads(), (ThreadFactory)new NamedThreadFactory("NettyServerSelectorThread_", true));
    }

    @Override
    protected void serverStart() throws RemotingException {
        NettyLogger.setNettyLoggerFactory();
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.remotingServerConfig.getServerWorkerThreads(), (ThreadFactory)new NamedThreadFactory("NettyServerWorkerThread_"));
        final NettyCodecFactory nettyCodecFactory = new NettyCodecFactory(this.appContext, this.getCodec());
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.bossSelectorGroup, this.workerSelectorGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)65536)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(this.remotingServerConfig.getListenPort()))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, new ChannelHandler[]{nettyCodecFactory.getEncoder(), nettyCodecFactory.getDecoder(), new IdleStateHandler(NettyRemotingServer.this.remotingServerConfig.getReaderIdleTimeSeconds(), NettyRemotingServer.this.remotingServerConfig.getWriterIdleTimeSeconds(), NettyRemotingServer.this.remotingServerConfig.getServerChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyServerHandler()});
            }
        });
        try {
            this.serverBootstrap.bind().sync();
        }
        catch (InterruptedException e) {
            throw new RemotingException("Start Netty server bootstrap error", e);
        }
    }

    @Override
    protected void serverShutdown() throws RemotingException {
        this.bossSelectorGroup.shutdownGracefully();
        this.workerSelectorGroup.shutdownGracefully();
        if (this.defaultEventExecutorGroup != null) {
            this.defaultEventExecutorGroup.shutdownGracefully();
        }
    }

    class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        NettyConnectManageHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(new NettyChannel(ctx));
            LOGGER.info("SERVER : channelRegistered {}", remoteAddress);
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(new NettyChannel(ctx));
            LOGGER.info("SERVER : channelUnregistered, the channel[{}]", remoteAddress);
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyChannel channel = new NettyChannel(ctx);
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
            LOGGER.info("SERVER: channelActive, the channel[{}]", remoteAddress);
            super.channelActive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putRemotingEvent(new RemotingEvent(RemotingEventType.CONNECT, remoteAddress, channel));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            NettyChannel channel = new NettyChannel(ctx);
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
            LOGGER.info("SERVER: channelInactive, the channel[{}]", remoteAddress);
            super.channelInactive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putRemotingEvent(new RemotingEvent(RemotingEventType.CLOSE, remoteAddress, channel));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent event = (IdleStateEvent)evt;
                NettyChannel channel = new NettyChannel(ctx);
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
                if (event.state().equals((Object)IdleState.ALL_IDLE)) {
                    LOGGER.warn("SERVER: IDLE [{}]", remoteAddress);
                    RemotingHelper.closeChannel(channel);
                }
                if (NettyRemotingServer.this.channelEventListener != null) {
                    RemotingEventType remotingEventType = RemotingEventType.valueOf(event.state().name());
                    NettyRemotingServer.this.putRemotingEvent(new RemotingEvent(remotingEventType, remoteAddress, channel));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyChannel channel = new NettyChannel(ctx);
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
            LOGGER.warn("SERVER: exceptionCaught {}", remoteAddress, cause);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putRemotingEvent(new RemotingEvent(RemotingEventType.EXCEPTION, remoteAddress, channel));
            }
            RemotingHelper.closeChannel(channel);
        }
    }

    class NettyServerHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingServer.this.processMessageReceived(new NettyChannel(ctx), msg);
        }
    }
}

