/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.mina;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.remoting.AbstractRemoting;
import com.github.ltsopensource.remoting.RemotingEvent;
import com.github.ltsopensource.remoting.RemotingEventType;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.mina.MinaChannel;
import com.github.ltsopensource.remoting.mina.MinaRemotingClient;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;

public class MinaHandler
extends IoHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger("LtsRemoting");
    private AbstractRemoting remoting;
    private String sideType;

    public MinaHandler(AbstractRemoting remoting) {
        this.remoting = remoting;
        this.sideType = remoting instanceof MinaRemotingClient ? "CLIENT" : "SERVER";
    }

    public void sessionCreated(IoSession session) throws Exception {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(new MinaChannel(session));
        LOGGER.info("{} : sessionCreated {}", this.sideType, remoteAddress);
        super.sessionCreated(session);
    }

    public void sessionOpened(IoSession session) throws Exception {
        MinaChannel channel = new MinaChannel(session);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
        LOGGER.info("{}: sessionOpened, the channel[{}]", this.sideType, remoteAddress);
        if (this.remoting.getChannelEventListener() != null) {
            this.remoting.putRemotingEvent(new RemotingEvent(RemotingEventType.CONNECT, remoteAddress, channel));
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        MinaChannel channel = new MinaChannel(session);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
        LOGGER.info("{}: sessionClosed, the channel[{}]", this.sideType, remoteAddress);
        if (this.remoting.getChannelEventListener() != null) {
            this.remoting.putRemotingEvent(new RemotingEvent(RemotingEventType.CLOSE, remoteAddress, channel));
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        MinaChannel channel = new MinaChannel(session);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
        if (IdleStatus.BOTH_IDLE == status) {
            LOGGER.info("{}: IDLE [{}]", this.sideType, remoteAddress);
            RemotingHelper.closeChannel(channel);
        }
        if (this.remoting.getChannelEventListener() != null) {
            RemotingEventType remotingEventType = null;
            if (IdleStatus.BOTH_IDLE == status) {
                remotingEventType = RemotingEventType.ALL_IDLE;
            } else if (IdleStatus.READER_IDLE == status) {
                remotingEventType = RemotingEventType.READER_IDLE;
            } else if (IdleStatus.WRITER_IDLE == status) {
                remotingEventType = RemotingEventType.WRITER_IDLE;
            }
            this.remoting.putRemotingEvent(new RemotingEvent(remotingEventType, remoteAddress, channel));
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        MinaChannel channel = new MinaChannel(session);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
        LOGGER.warn("{}: exceptionCaught {}. ", this.sideType, remoteAddress, cause);
        if (this.remoting.getChannelEventListener() != null) {
            this.remoting.putRemotingEvent(new RemotingEvent(RemotingEventType.EXCEPTION, remoteAddress, channel));
        }
        RemotingHelper.closeChannel(channel);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message != null && message instanceof RemotingCommand) {
            this.remoting.processMessageReceived(new MinaChannel(session), (RemotingCommand)message);
        }
    }
}

