/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.lts;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.handler.NioHandler;
import com.github.ltsopensource.nio.idle.IdleState;
import com.github.ltsopensource.remoting.AbstractRemoting;
import com.github.ltsopensource.remoting.RemotingEvent;
import com.github.ltsopensource.remoting.RemotingEventType;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.lts.LtsChannel;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;

public class LtsEventHandler
implements NioHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger("LtsRemoting");
    private AbstractRemoting remoting;
    private String sideType;

    public LtsEventHandler(AbstractRemoting remoting, String sideType) {
        this.remoting = remoting;
        this.sideType = sideType;
    }

    @Override
    public void exceptionCaught(NioChannel channel, Exception cause) {
        LtsChannel ch = new LtsChannel(channel);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ch);
        LOGGER.warn(this.sideType + ": exceptionCaught {}", remoteAddress, cause);
        if (this.remoting.getChannelEventListener() != null) {
            this.remoting.putRemotingEvent(new RemotingEvent(RemotingEventType.EXCEPTION, remoteAddress, ch));
        }
        RemotingHelper.closeChannel(ch);
    }

    @Override
    public void messageReceived(NioChannel channel, Object msg) throws Exception {
        if (msg != null && msg instanceof RemotingCommand) {
            this.remoting.processMessageReceived(new LtsChannel(channel), (RemotingCommand)msg);
        }
    }

    @Override
    public void channelConnected(NioChannel channel) {
        LtsChannel ch = new LtsChannel(channel);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ch);
        LOGGER.info("{}: channelConnected, the channel[{}]", this.sideType, remoteAddress);
        if (this.remoting.getChannelEventListener() != null) {
            this.remoting.putRemotingEvent(new RemotingEvent(RemotingEventType.CONNECT, remoteAddress, ch));
        }
    }

    @Override
    public void channelIdle(NioChannel channel, IdleState state) {
        if (state == null) {
            return;
        }
        LtsChannel ch = new LtsChannel(channel);
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ch);
        if (IdleState.BOTH_IDLE == state) {
            LOGGER.info("{}: IDLE [{}]", this.sideType, remoteAddress);
            RemotingHelper.closeChannel(ch);
        }
        if (this.remoting.getChannelEventListener() != null) {
            RemotingEventType remotingEventType = null;
            switch (state) {
                case BOTH_IDLE: {
                    remotingEventType = RemotingEventType.ALL_IDLE;
                    break;
                }
                case READER_IDLE: {
                    remotingEventType = RemotingEventType.READER_IDLE;
                    break;
                }
                case WRITER_IDLE: {
                    remotingEventType = RemotingEventType.WRITER_IDLE;
                }
            }
            this.remoting.putRemotingEvent(new RemotingEvent(remotingEventType, remoteAddress, ch));
        }
    }
}

