/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.common;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.ChannelHandlerListener;
import com.github.ltsopensource.remoting.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class RemotingHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger("LtsRemoting");
    public static final String RemotingLogName = "LtsRemoting";

    public static SocketAddress string2SocketAddress(String addr) {
        String[] s = addr.split(":");
        return new InetSocketAddress(s[0], (int)Integer.valueOf(s[1]));
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static void closeChannel(Channel channel) {
        final String addrRemote = RemotingHelper.parseChannelRemoteAddr(channel);
        channel.close().addListener(new ChannelHandlerListener(){

            @Override
            public void operationComplete(Future future) throws Exception {
                LOGGER.info("closeChannel: close the connection to remote address[{}] result: {}", addrRemote, future.isSuccess());
            }
        });
    }
}

