/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.codec;

import com.github.ltsopensource.remoting.RemotingCommandBody;
import com.github.ltsopensource.remoting.codec.AbstractCodec;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.serialize.RemotingSerializable;
import java.nio.ByteBuffer;

public class DefaultCodec
extends AbstractCodec {
    @Override
    public RemotingCommand decode(ByteBuffer byteBuffer) throws Exception {
        int length = byteBuffer.limit();
        int serializableId = byteBuffer.getInt();
        RemotingSerializable serializable = this.getRemotingSerializable(serializableId);
        int headerLength = byteBuffer.getInt();
        byte[] headerData = new byte[headerLength];
        byteBuffer.get(headerData);
        RemotingCommand cmd = serializable.deserialize(headerData, RemotingCommand.class);
        int remaining = length - 4 - 4 - headerLength;
        if (remaining > 0) {
            int bodyLength = byteBuffer.getInt();
            int bodyClassLength = remaining - 4 - bodyLength;
            if (bodyLength > 0) {
                byte[] bodyData = new byte[bodyLength];
                byteBuffer.get(bodyData);
                byte[] bodyClassData = new byte[bodyClassLength];
                byteBuffer.get(bodyClassData);
                cmd.setBody((RemotingCommandBody)serializable.deserialize(bodyData, Class.forName(new String(bodyClassData))));
            }
        }
        return cmd;
    }

    @Override
    public ByteBuffer encode(RemotingCommand remotingCommand) throws Exception {
        RemotingSerializable serializable = this.getRemotingSerializable(remotingCommand.getSid());
        int length = 4;
        length += 4;
        byte[] headerData = serializable.serialize(remotingCommand);
        length += headerData.length;
        byte[] bodyData = null;
        byte[] bodyClass = null;
        Object body = remotingCommand.getBody();
        if (body != null) {
            bodyData = serializable.serialize(body);
            length += bodyData.length;
            bodyClass = body.getClass().getName().getBytes();
            length += bodyClass.length;
            length += 4;
        }
        ByteBuffer result = ByteBuffer.allocate(4 + length);
        result.putInt(length);
        result.putInt(serializable.getId());
        result.putInt(headerData.length);
        result.put(headerData);
        if (bodyData != null) {
            result.putInt(bodyData.length);
            result.put(bodyData);
            result.put(bodyClass);
        }
        result.flip();
        return result;
    }
}

