/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting;

import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.remoting.AbstractRemoting;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.ChannelFuture;
import com.github.ltsopensource.remoting.RemotingClient;
import com.github.ltsopensource.remoting.RemotingClientConfig;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.exception.RemotingConnectException;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.exception.RemotingSendRequestException;
import com.github.ltsopensource.remoting.exception.RemotingTimeoutException;
import com.github.ltsopensource.remoting.exception.RemotingTooMuchRequestException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRemotingClient
extends AbstractRemoting
implements RemotingClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger("LtsRemoting");
    private static final long LockTimeoutMillis = 3000L;
    protected final RemotingClientConfig remotingClientConfig;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentHashMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final ExecutorService publicExecutor;

    public AbstractRemotingClient(RemotingClientConfig remotingClientConfig, ChannelEventListener channelEventListener) {
        super(remotingClientConfig.getClientOnewaySemaphoreValue(), remotingClientConfig.getClientAsyncSemaphoreValue(), channelEventListener);
        this.remotingClientConfig = remotingClientConfig;
        int publicThreadNums = remotingClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new NamedThreadFactory("RemotingClientPublicExecutor", true));
    }

    @Override
    public void start() throws RemotingException {
        this.clientStart();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    AbstractRemotingClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    LOGGER.error("scanResponseTable exception", e);
                }
            }
        }, 3000L, 1000L);
        if (this.channelEventListener != null) {
            this.remotingEventExecutor.start();
        }
    }

    protected abstract void clientStart() throws RemotingException;

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            if (this.remotingEventExecutor != null) {
                this.remotingEventExecutor.shutdown();
            }
            this.clientShutdown();
        }
        catch (Exception e) {
            LOGGER.error("NettyRemotingClient shutdown exception, ", e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("NettyRemotingServer shutdown exception, ", e);
            }
        }
    }

    protected abstract void clientShutdown();

    private Channel getAndCreateChannel(String addr) throws InterruptedException {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isConnected()) {
            return cw.getChannel();
        }
        return this.createChannel(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Channel createChannel(String addr) throws InterruptedException {
        cw = this.channelTables.get(addr);
        if (cw != null && cw.isConnected()) {
            return ChannelWrapper.access$000(cw);
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                createNewConnection = false;
                cw = this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isConnected()) {
                        var4_6 = ChannelWrapper.access$000(cw);
                        return var4_6;
                    }
                    if (!ChannelWrapper.access$100(cw).isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl34
                channelFuture = this.connect(RemotingHelper.string2SocketAddress(addr));
                AbstractRemotingClient.LOGGER.info("createChannel: begin to connect remote host[{}] asynchronously", new Object[]{addr});
                cw = new ChannelWrapper(channelFuture);
                this.channelTables.put(addr, cw);
            }
            catch (Exception e) {
                AbstractRemotingClient.LOGGER.error("createChannel: create channel exception", e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            AbstractRemotingClient.LOGGER.warn("createChannel: try to lock channel table, but timeout, {}ms", new Object[]{3000L});
        }
lbl34:
        // 4 sources

        if (cw != null) {
            channelFuture = ChannelWrapper.access$100(cw);
            if (channelFuture.awaitUninterruptibly(this.remotingClientConfig.getConnectTimeoutMillis())) {
                if (cw.isConnected()) {
                    AbstractRemotingClient.LOGGER.info("createChannel: connect remote host[{}] success, {}", new Object[]{addr, channelFuture.toString()});
                    return ChannelWrapper.access$000(cw);
                }
                AbstractRemotingClient.LOGGER.warn("createChannel: connect remote host[" + addr + "] failed, " + channelFuture.toString(), channelFuture.cause());
            } else {
                AbstractRemotingClient.LOGGER.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{addr, this.remotingClientConfig.getConnectTimeoutMillis(), channelFuture.toString()});
            }
        }
        return null;
    }

    protected abstract ChannelFuture connect(SocketAddress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr(channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = this.channelTables.get(addrRemote);
                        LOGGER.info("closeChannel: begin close the channel[{}] Found: {}", addrRemote, prevCW != null);
                        if (null == prevCW) {
                            LOGGER.info("closeChannel: the channel[{}] has been removed from the channel table before", addrRemote);
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            LOGGER.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            LOGGER.info("closeChannel: the channel[{}] was removed from channel table", addrRemote);
                        }
                        RemotingHelper.closeChannel(channel);
                        break block13;
                    }
                    catch (Exception e) {
                        LOGGER.error("closeChannel: close the channel exception", e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                LOGGER.warn("closeChannel: try to lock channel table, but timeout, {}ms", 3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("closeChannel exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block12: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (String key : this.channelTables.keySet()) {
                            ChannelWrapper prev = this.channelTables.get(key);
                            if (prev.getChannel() == null || prev.getChannel() != channel) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            LOGGER.info("eventCloseChannel: the channel has been removed from the channel table before");
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            LOGGER.info("closeChannel: the channel[{}] was removed from channel table", addrRemote);
                            RemotingHelper.closeChannel(channel);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        LOGGER.error("closeChannel: close the channel exception", e);
                        break block12;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                LOGGER.warn("closeChannel: try to lock channel table, but timeout, {}ms", 3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("closeChannel exception", e);
            }
        }
    }

    @Override
    public void registerProcessor(int requestCode, RemotingProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair<RemotingProcessor, ExecutorService> pair = new Pair<RemotingProcessor, ExecutorService>(processor, executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public void registerDefaultProcessor(RemotingProcessor processor, ExecutorService executor) {
        this.defaultRequestProcessor = new Pair<RemotingProcessor, ExecutorService>(processor, executor);
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isConnected()) {
            try {
                return this.invokeSyncImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeSync: send request exception, so close the channel[{}]", addr);
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                LOGGER.warn("invokeSync: wait response timeout exception, the channel[{}]", addr);
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, AsyncCallback asyncCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isConnected()) {
            try {
                this.invokeAsyncImpl(channel, request, timeoutMillis, asyncCallback);
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeAsync: send request exception, so close the channel[{}]", addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isConnected()) {
            try {
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeOneway: send request exception, so close the channel[{}]", addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    protected ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    private class ChannelWrapper {
        private final ChannelFuture channelFuture;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        public boolean isConnected() {
            return this.channelFuture.isConnected();
        }

        private Channel getChannel() {
            return this.channelFuture.getChannel();
        }

        private ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }

        static /* synthetic */ ChannelFuture access$100(ChannelWrapper x0) {
            return x0.getChannelFuture();
        }
    }
}

