/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.SchedulerJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mongo.AbstractMongoJobQueue;
import java.util.List;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public abstract class MongoSchedulerJobQueue
extends AbstractMongoJobQueue
implements SchedulerJobQueue {
    public MongoSchedulerJobQueue(Config config) {
        super(config);
    }

    @Override
    public boolean updateLastGenerateTriggerTime(String jobId, Long lastGenerateTriggerTime) {
        Query<JobPo> query = this.template.createQuery(this.getTableName(), JobPo.class);
        query.field("jobId").equal((Object)jobId);
        UpdateOperations operations = this.template.createUpdateOperations(JobPo.class).set("lastGenerateTriggerTime", (Object)lastGenerateTriggerTime).set("gmtModified", (Object)SystemClock.now());
        UpdateResults ur = this.template.update(query, operations);
        return ur.getUpdatedCount() == 1;
    }

    @Override
    public List<JobPo> getNeedGenerateJobPos(Long checkTime, int topSize) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.field("relyOnPrevCycle").equal((Object)false);
        query.field("lastGenerateTriggerTime").equal((Object)checkTime);
        query.offset(0).limit(topSize);
        return query.asList();
    }
}

