/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.queue.RepeatJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mongo.MongoSchedulerJobQueue;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import com.mongodb.DBCollection;
import com.mongodb.DuplicateKeyException;
import com.mongodb.WriteResult;
import java.util.List;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public class MongoRepeatJobQueue
extends MongoSchedulerJobQueue
implements RepeatJobQueue {
    public MongoRepeatJobQueue(Config config) {
        super(config);
        this.setTableName("lts_repeat_job_queue");
        DBCollection dbCollection = this.template.getCollection();
        List indexInfo = dbCollection.getIndexInfo();
        if (CollectionUtils.sizeOf(indexInfo) <= 1) {
            this.template.ensureIndex("idx_jobId", "jobId", true, true);
            this.template.ensureIndex("idx_taskId_taskTrackerNodeGroup", "taskId, taskTrackerNodeGroup", true, true);
            this.template.ensureIndex("idx_realTaskId_taskTrackerNodeGroup", "realTaskId, taskTrackerNodeGroup");
            this.template.ensureIndex("idx_relyOnPrevCycle_lgtt", "relyOnPrevCycle, lastGenerateTriggerTime");
        }
    }

    @Override
    protected String getTargetTable(String taskTrackerNodeGroup) {
        return "lts_repeat_job_queue";
    }

    @Override
    public boolean add(JobPo jobPo) {
        try {
            this.template.save(jobPo);
        }
        catch (DuplicateKeyException e) {
            throw new DupEntryException(e);
        }
        return true;
    }

    @Override
    public JobPo getJob(String jobId) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.field("jobId").equal((Object)jobId);
        return (JobPo)query.get();
    }

    @Override
    public boolean remove(String jobId) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        query.field("jobId").equal((Object)jobId);
        WriteResult wr = this.template.delete(query);
        return wr.getN() == 1;
    }

    @Override
    public JobPo getJob(String taskTrackerNodeGroup, String taskId) {
        Query<JobPo> query = this.template.createQuery(JobPo.class);
        ((Query)query.field("taskId").equal((Object)taskId)).field("taskTrackerNodeGroup").equal((Object)taskTrackerNodeGroup);
        return (JobPo)query.get();
    }

    @Override
    public int incRepeatedCount(String jobId) {
        JobPo jobPo;
        UpdateOperations<JobPo> opts;
        Query<JobPo> query;
        UpdateResults ur;
        do {
            if ((jobPo = this.getJob(jobId)) == null) {
                return -1;
            }
            query = this.template.createQuery(JobPo.class);
            query.field("jobId").equal((Object)jobId);
            query.field("repeatedCount").equal((Object)jobPo.getRepeatedCount());
            opts = this.template.createUpdateOperations(JobPo.class);
            opts.set("repeatedCount", (Object)(jobPo.getRepeatedCount() + 1));
        } while ((ur = this.template.update(query, opts)).getUpdatedCount() != 1);
        return jobPo.getRepeatedCount() + 1;
    }
}

