/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.support.JobQueueUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.AbstractPreLoader;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.mongo.DataStoreProvider;
import com.github.ltsopensource.store.mongo.MongoTemplate;
import java.util.List;
import org.mongodb.morphia.AdvancedDatastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public class MongoPreLoader
extends AbstractPreLoader {
    private MongoTemplate template;

    public MongoPreLoader(AppContext appContext) {
        super(appContext);
        this.template = new MongoTemplate((AdvancedDatastore)DataStoreProvider.getDataStore(appContext.getConfig()));
    }

    @Override
    protected boolean lockJob(String taskTrackerNodeGroup, String jobId, String taskTrackerIdentity, Long triggerTime, Long gmtModified) {
        UpdateOperations operations = this.template.createUpdateOperations(JobPo.class).set("isRunning", (Object)true).set("taskTrackerIdentity", (Object)taskTrackerIdentity).set("gmtModified", (Object)SystemClock.now());
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        Query<JobPo> updateQuery = this.template.createQuery(tableName, JobPo.class);
        ((Query)((Query)((Query)updateQuery.field("jobId").equal((Object)jobId)).field("isRunning").equal((Object)false)).field("triggerTime").equal((Object)triggerTime)).field("gmtModified").equal((Object)gmtModified);
        UpdateResults updateResult = this.template.update(updateQuery, operations);
        return updateResult.getUpdatedCount() == 1;
    }

    @Override
    protected List<JobPo> load(String loadTaskTrackerNodeGroup, int loadSize) {
        String tableName = JobQueueUtils.getExecutableQueueName(loadTaskTrackerNodeGroup);
        Query<JobPo> query = this.template.createQuery(tableName, JobPo.class);
        ((Query)query.field("isRunning").equal((Object)false)).filter("triggerTime < ", (Object)SystemClock.now()).order(" triggerTime, priority , gmtCreated").offset(0).limit(loadSize);
        return query.asList();
    }
}

