/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.NodeGroupGetReq;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.NodeGroupStore;
import com.github.ltsopensource.queue.domain.NodeGroupPo;
import com.github.ltsopensource.store.mongo.MongoRepository;
import com.mongodb.DBCollection;
import com.mongodb.DuplicateKeyException;
import java.util.List;
import org.mongodb.morphia.query.Query;

public class MongoNodeGroupStore
extends MongoRepository
implements NodeGroupStore {
    public MongoNodeGroupStore(Config config) {
        super(config);
        this.setTableName("lts_node_group_store");
        DBCollection dbCollection = this.template.getCollection();
        List indexInfo = dbCollection.getIndexInfo();
        if (CollectionUtils.sizeOf(indexInfo) <= 1) {
            this.template.ensureIndex("idx_nodeType_name", "nodeType,name", true, true);
        }
    }

    @Override
    public void addNodeGroup(NodeType nodeType, String name) {
        try {
            NodeGroupPo nodeGroupPo = new NodeGroupPo();
            nodeGroupPo.setNodeType(nodeType);
            nodeGroupPo.setName(name);
            nodeGroupPo.setGmtCreated(SystemClock.now());
            this.template.save(nodeGroupPo);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    @Override
    public void removeNodeGroup(NodeType nodeType, String name) {
        Query<NodeGroupPo> query = this.template.createQuery(NodeGroupPo.class);
        ((Query)query.field("nodeType").equal((Object)nodeType)).field("name").equal((Object)name);
        this.template.delete(query);
    }

    @Override
    public List<NodeGroupPo> getNodeGroup(NodeType nodeType) {
        Query<NodeGroupPo> query = this.template.createQuery(NodeGroupPo.class);
        query.field("nodeType").equal((Object)nodeType);
        return query.asList();
    }

    @Override
    public PaginationRsp<NodeGroupPo> getNodeGroup(NodeGroupGetReq request) {
        Query<NodeGroupPo> query = this.template.createQuery(NodeGroupPo.class);
        if (request.getNodeType() != null) {
            query.field("nodeType").equal((Object)request.getNodeType());
        }
        if (StringUtils.isNotEmpty(request.getNodeGroup())) {
            query.field("name").equal((Object)request.getNodeGroup());
        }
        PaginationRsp<NodeGroupPo> response = new PaginationRsp<NodeGroupPo>();
        Long results = this.template.getCount(query);
        response.setResults(results.intValue());
        if (results == 0L) {
            return response;
        }
        query.order("-gmtCreated").offset(request.getStart().intValue()).limit(request.getLimit().intValue());
        response.setRows(query.asList());
        return response;
    }
}

