/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.JobQueueUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.ExecutableJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mongo.AbstractMongoJobQueue;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import com.mongodb.DBCollection;
import com.mongodb.DuplicateKeyException;
import com.mongodb.WriteResult;
import java.util.List;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;

public class MongoExecutableJobQueue
extends AbstractMongoJobQueue
implements ExecutableJobQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoExecutableJobQueue.class);
    private ConcurrentHashSet<String> EXIST_TABLE = new ConcurrentHashSet();

    public MongoExecutableJobQueue(Config config) {
        super(config);
    }

    @Override
    protected String getTargetTable(String taskTrackerNodeGroup) {
        if (StringUtils.isEmpty(taskTrackerNodeGroup)) {
            throw new JdbcException("taskTrackerNodeGroup can not be null");
        }
        return JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
    }

    @Override
    public boolean createQueue(String taskTrackerNodeGroup) {
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        DBCollection dbCollection = this.template.getCollection(tableName);
        List indexInfo = dbCollection.getIndexInfo();
        if (CollectionUtils.sizeOf(indexInfo) <= 1) {
            this.template.ensureIndex(tableName, "idx_jobId", "jobId", true, true);
            this.template.ensureIndex(tableName, "idx_taskId_taskTrackerNodeGroup", "taskId, taskTrackerNodeGroup", true, true);
            this.template.ensureIndex(tableName, "idx_taskTrackerIdentity", "taskTrackerIdentity");
            this.template.ensureIndex(tableName, "idx_jobType", "jobType");
            this.template.ensureIndex(tableName, "idx_realTaskId_taskTrackerNodeGroup", "realTaskId, taskTrackerNodeGroup");
            this.template.ensureIndex(tableName, "idx_triggerTime_priority_gmtCreated", "triggerTime,priority,gmtCreated");
            this.template.ensureIndex(tableName, "idx_isRunning", "isRunning");
            LOGGER.info("create queue " + tableName);
        }
        this.EXIST_TABLE.add(tableName);
        return true;
    }

    @Override
    public boolean removeQueue(String taskTrackerNodeGroup) {
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        DBCollection dbCollection = this.template.getCollection(tableName);
        dbCollection.drop();
        LOGGER.info("drop queue " + tableName);
        return true;
    }

    @Override
    public boolean add(JobPo jobPo) {
        try {
            String tableName = JobQueueUtils.getExecutableQueueName(jobPo.getTaskTrackerNodeGroup());
            if (!this.EXIST_TABLE.contains(tableName)) {
                this.createQueue(jobPo.getTaskTrackerNodeGroup());
            }
            jobPo.setGmtCreated(SystemClock.now());
            jobPo.setGmtModified(jobPo.getGmtCreated());
            this.template.save(tableName, jobPo);
        }
        catch (DuplicateKeyException e) {
            throw new DupEntryException(e);
        }
        return true;
    }

    @Override
    public boolean remove(String taskTrackerNodeGroup, String jobId) {
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        Query<JobPo> query = this.template.createQuery(tableName, JobPo.class);
        query.field("jobId").equal((Object)jobId);
        WriteResult wr = this.template.delete(query);
        return wr.getN() == 1;
    }

    @Override
    public boolean removeBatch(String realTaskId, String taskTrackerNodeGroup) {
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        Query<JobPo> query = this.template.createQuery(tableName, JobPo.class);
        query.field("realTaskId").equal((Object)realTaskId);
        query.field("taskTrackerNodeGroup").equal((Object)taskTrackerNodeGroup);
        this.template.delete(query);
        return true;
    }

    @Override
    public void resume(JobPo jobPo) {
        String tableName = JobQueueUtils.getExecutableQueueName(jobPo.getTaskTrackerNodeGroup());
        Query<JobPo> query = this.template.createQuery(tableName, JobPo.class);
        query.field("jobId").equal((Object)jobPo.getJobId());
        UpdateOperations operations = this.template.createUpdateOperations(JobPo.class).set("isRunning", (Object)false).set("taskTrackerIdentity", (Object)"").set("gmtModified", (Object)SystemClock.now());
        this.template.update(query, operations);
    }

    @Override
    public List<JobPo> getDeadJob(String taskTrackerNodeGroup, long deadline) {
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        Query<JobPo> query = this.template.createQuery(tableName, JobPo.class);
        ((Query)query.field("isRunning").equal((Object)true)).filter("gmtCreated < ", (Object)deadline);
        return query.asList();
    }

    @Override
    public JobPo getJob(String taskTrackerNodeGroup, String taskId) {
        String tableName = JobQueueUtils.getExecutableQueueName(taskTrackerNodeGroup);
        Query<JobPo> query = this.template.createQuery(tableName, JobPo.class);
        ((Query)query.field("taskId").equal((Object)taskId)).field("taskTrackerNodeGroup").equal((Object)taskTrackerNodeGroup);
        return (JobPo)query.get();
    }
}

