/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.JobPriorityBlockingQueue;
import com.github.ltsopensource.queue.PreLoader;
import com.github.ltsopensource.queue.domain.JobPo;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractPreLoader
implements PreLoader {
    private int loadSize;
    private double factor;
    private ConcurrentHashMap<String, JobPriorityBlockingQueue> JOB_MAP = new ConcurrentHashMap();
    private ConcurrentHashSet<String> LOAD_SIGNAL = new ConcurrentHashSet();
    private ScheduledExecutorService LOAD_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("LTS-PreLoader", true));
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean start = new AtomicBoolean(false);
    private String FORCE_PREFIX = "force_";

    public AbstractPreLoader(AppContext appContext) {
        if (this.start.compareAndSet(false, true)) {
            this.loadSize = appContext.getConfig().getParameter("job.preloader.size", 300);
            this.factor = appContext.getConfig().getParameter("job.preloader.factor", 0.2);
            this.scheduledFuture = this.LOAD_EXECUTOR_SERVICE.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    for (String loadTaskTrackerNodeGroup : AbstractPreLoader.this.LOAD_SIGNAL) {
                        List<JobPo> loads;
                        boolean force = false;
                        if (loadTaskTrackerNodeGroup.startsWith(AbstractPreLoader.this.FORCE_PREFIX)) {
                            loadTaskTrackerNodeGroup = loadTaskTrackerNodeGroup.replaceFirst(AbstractPreLoader.this.FORCE_PREFIX, "");
                            force = true;
                        }
                        JobPriorityBlockingQueue queue = (JobPriorityBlockingQueue)AbstractPreLoader.this.JOB_MAP.get(loadTaskTrackerNodeGroup);
                        if ((force || (double)(queue.size() / AbstractPreLoader.this.loadSize) < AbstractPreLoader.this.factor) && CollectionUtils.isNotEmpty(loads = AbstractPreLoader.this.load(loadTaskTrackerNodeGroup, AbstractPreLoader.this.loadSize - queue.size()))) {
                            for (JobPo load : loads) {
                                if (!queue.offer(load)) break;
                            }
                        }
                        AbstractPreLoader.this.LOAD_SIGNAL.remove(loadTaskTrackerNodeGroup);
                    }
                }
            }, 500L, 500L, TimeUnit.MILLISECONDS);
            NodeShutdownHook.registerHook(appContext, this.getClass().getName(), new Callable(){

                @Override
                public void call() throws Exception {
                    AbstractPreLoader.this.scheduledFuture.cancel(true);
                    AbstractPreLoader.this.LOAD_EXECUTOR_SERVICE.shutdown();
                    AbstractPreLoader.this.start.set(false);
                }
            });
        }
    }

    @Override
    public JobPo take(String taskTrackerNodeGroup, String taskTrackerIdentity) {
        JobPo jobPo;
        do {
            if ((jobPo = this.get(taskTrackerNodeGroup)) != null) continue;
            return null;
        } while (!this.lockJob(taskTrackerNodeGroup, jobPo.getJobId(), taskTrackerIdentity, jobPo.getTriggerTime(), jobPo.getGmtModified()));
        jobPo.setTaskTrackerIdentity(taskTrackerIdentity);
        jobPo.setIsRunning(true);
        jobPo.setGmtModified(SystemClock.now());
        return jobPo;
    }

    @Override
    public void load(String taskTrackerNodeGroup) {
        if (StringUtils.isEmpty(taskTrackerNodeGroup)) {
            for (String key : this.JOB_MAP.keySet()) {
                this.LOAD_SIGNAL.add(this.FORCE_PREFIX + key);
            }
            return;
        }
        this.LOAD_SIGNAL.add(this.FORCE_PREFIX + taskTrackerNodeGroup);
    }

    protected abstract boolean lockJob(String var1, String var2, String var3, Long var4, Long var5);

    protected abstract List<JobPo> load(String var1, int var2);

    private JobPo get(String taskTrackerNodeGroup) {
        JobPriorityBlockingQueue oldQueue;
        JobPriorityBlockingQueue queue = this.JOB_MAP.get(taskTrackerNodeGroup);
        if (queue == null && (oldQueue = this.JOB_MAP.putIfAbsent(taskTrackerNodeGroup, queue = new JobPriorityBlockingQueue(this.loadSize))) != null) {
            queue = oldQueue;
        }
        if ((double)(queue.size() / this.loadSize) < this.factor && !this.LOAD_SIGNAL.contains(taskTrackerNodeGroup)) {
            this.LOAD_SIGNAL.add(taskTrackerNodeGroup);
        }
        return queue.poll();
    }
}

