/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.txlog;

import com.github.ltsopensource.kv.AbstractFileHeader;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class StoreTxLogFileHeader
extends AbstractFileHeader {
    private static final short magic = -16894;
    private long firstRecordId;

    public long getFirstRecordId() {
        return this.firstRecordId;
    }

    public void setFirstRecordId(long firstRecordId) {
        this.firstRecordId = firstRecordId;
    }

    @Override
    public int getLength() {
        return 10;
    }

    @Override
    public void read(FileChannel fileChannel) throws IOException {
        fileChannel.position(0L);
        fileChannel.read(this.byteBuffer());
        this.byteBuffer().position(0);
        short readMagic = this.byteBuffer().getShort();
        if (readMagic != -16894) {
            throw new IOException("Invalid file type magic number 0x" + Integer.toHexString(readMagic & 0xFFFF));
        }
        this.firstRecordId = this.byteBuffer().getLong();
    }

    @Override
    public void write(FileChannel fileChannel) throws IOException {
        this.byteBuffer().position(0);
        this.byteBuffer().putShort((short)-16894);
        this.byteBuffer().putLong(this.firstRecordId);
        this.byteBuffer().flip();
        fileChannel.position(0L);
        fileChannel.write(this.byteBuffer());
        fileChannel.force(true);
    }
}

