/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.index;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.io.UnsafeByteArrayInputStream;
import com.github.ltsopensource.core.commons.io.UnsafeByteArrayOutputStream;
import com.github.ltsopensource.core.json.TypeReference;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.index.AbstractIndexSnapshot;
import com.github.ltsopensource.kv.index.Index;
import com.github.ltsopensource.kv.index.IndexItem;
import com.github.ltsopensource.kv.index.IndexSnapshotFileHeader;
import com.github.ltsopensource.kv.index.MemIndex;
import com.github.ltsopensource.kv.replay.TxLogReplay;
import com.github.ltsopensource.kv.serializer.StoreSerializer;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class MemIndexSnapshot<K, V>
extends AbstractIndexSnapshot<K, V> {
    private TxLogReplay<K, V> txLogReplay;
    private StoreTxLogPosition lastStoreTxLogPosition;

    public MemIndexSnapshot(TxLogReplay<K, V> txLogReplay, Index<K, V> index, StoreConfig storeConfig, StoreSerializer serializer) {
        super(index, storeConfig, serializer);
        this.txLogReplay = txLogReplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFromDisk() throws IOException {
        FileUtils.createDirIfNotExist(this.storeConfig.getIndexPath());
        String[] indexFiles = this.getIndexFiles();
        if (indexFiles == null || indexFiles.length == 0) {
            return;
        }
        AbstractInterruptibleChannel fileChannel = null;
        try {
            File lastSnapshot = new File(this.storeConfig.getIndexPath(), indexFiles[indexFiles.length - 1]);
            fileChannel = FileUtils.newFileChannel(lastSnapshot, "rw");
            IndexSnapshotFileHeader fileHeader = new IndexSnapshotFileHeader();
            fileHeader.read((FileChannel)fileChannel);
            ConcurrentMap indexMap = null;
            if (fileHeader.getStoreTxLogRecordId() != 0L) {
                UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
                WritableByteChannel target = Channels.newChannel(os);
                long readLength = ((FileChannel)fileChannel).size() - (long)fileHeader.getLength();
                if (readLength != 0L) {
                    ((FileChannel)fileChannel).transferTo(fileHeader.getLength(), readLength, target);
                    UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(os.toByteArray());
                    indexMap = (ConcurrentMap)this.serializer.deserialize(is, new TypeReference<ConcurrentSkipListMap<K, IndexItem<K>>>(){}.getType());
                }
            }
            if (indexMap == null) {
                indexMap = new ConcurrentSkipListMap();
            }
            ((MemIndex)this.index).setIndexMap(indexMap);
            StoreTxLogPosition lastTxLog = new StoreTxLogPosition();
            lastTxLog.setRecordId(fileHeader.getStoreTxLogRecordId());
            ((MemIndex)this.index).setLastTxLog(lastTxLog);
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
    }

    private String[] getIndexFiles() throws IOException {
        String[] indexFiles = this.storeConfig.getIndexPath().list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".snapshot");
            }
        });
        if (indexFiles == null) {
            throw new IOException("can't list file in " + this.storeConfig.getIndexPath());
        }
        if (indexFiles.length == 0) {
            return null;
        }
        Arrays.sort(indexFiles, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return left.compareTo(right);
            }
        });
        return indexFiles;
    }

    @Override
    protected void replayTxLog() {
        StoreTxLogPosition indexTxLog = this.index.lastTxLog();
        StoreTxLogPosition dataTxLog = this.storeConfig.getLastTxLogPositionOnDataBlock();
        StoreTxLogPosition replayTxLog = null;
        if (dataTxLog == null) {
            replayTxLog = indexTxLog;
        } else if (indexTxLog == null) {
            replayTxLog = dataTxLog;
        } else {
            StoreTxLogPosition storeTxLogPosition = replayTxLog = indexTxLog.getRecordId() < dataTxLog.getRecordId() ? indexTxLog : dataTxLog;
        }
        if (replayTxLog == null) {
            return;
        }
        this.txLogReplay.replay(replayTxLog);
    }

    @Override
    public void snapshot() throws IOException {
        StoreTxLogPosition storeTxLogPosition = this.index.lastTxLog();
        if (storeTxLogPosition == null) {
            return;
        }
        if (this.lastStoreTxLogPosition != null && this.lastStoreTxLogPosition.getRecordId() == storeTxLogPosition.getRecordId()) {
            return;
        }
        ConcurrentMap indexMap = ((MemIndex)this.index).getIndexMap();
        String name = System.currentTimeMillis() + ".snapshot";
        File snapshot = new File(this.storeConfig.getIndexPath(), name);
        FileChannel fileChannel = FileUtils.newFileChannel(snapshot, "rw");
        IndexSnapshotFileHeader fileHeader = new IndexSnapshotFileHeader();
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
        this.serializer.serialize(indexMap, os);
        byte[] payload = os.toByteArray();
        ReadableByteChannel src = Channels.newChannel(new UnsafeByteArrayInputStream(payload));
        fileHeader.write(fileChannel);
        fileChannel.transferFrom(src, fileHeader.getLength(), payload.length);
        fileChannel.force(true);
        fileHeader.setStoreTxLogRecordId(storeTxLogPosition.getRecordId());
        fileHeader.write(fileChannel);
        this.deleteOverSnapshot();
        LOGGER.info("snapshot index finished: [" + name + "]");
        this.lastStoreTxLogPosition = storeTxLogPosition;
    }

    private void deleteOverSnapshot() throws IOException {
        String[] indexFiles = this.getIndexFiles();
        if (indexFiles == null || indexFiles.length == 0) {
            return;
        }
        if (this.storeConfig.getMaxIndexSnapshotSize() > 1 && indexFiles.length > this.storeConfig.getMaxIndexSnapshotSize()) {
            for (int i = 0; i < indexFiles.length - this.storeConfig.getMaxIndexSnapshotSize(); ++i) {
                FileUtils.delete(new File(this.storeConfig.getIndexPath(), indexFiles[i]));
                LOGGER.info("delete index snapshot [" + indexFiles[i] + "] succeed");
            }
        }
    }
}

