/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.index;

import com.github.ltsopensource.kv.AbstractFileHeader;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class IndexSnapshotFileHeader
extends AbstractFileHeader {
    private static final short magic = -16893;
    private long storeTxLogRecordId;

    @Override
    public int getLength() {
        return 10;
    }

    @Override
    public void read(FileChannel fileChannel) throws IOException {
        fileChannel.position(0L);
        fileChannel.read(this.byteBuffer());
        this.byteBuffer().position(0);
        short readMagic = this.byteBuffer().getShort();
        if (readMagic != -16893) {
            throw new IOException("Invalid file type magic number 0x" + Integer.toHexString(readMagic & 0xFFFF));
        }
        this.storeTxLogRecordId = this.byteBuffer().getLong();
    }

    @Override
    public void write(FileChannel fileChannel) throws IOException {
        this.byteBuffer().position(0);
        this.byteBuffer().putShort((short)-16893);
        this.byteBuffer().putLong(this.storeTxLogRecordId);
        this.byteBuffer().flip();
        fileChannel.position(0L);
        fileChannel.write(this.byteBuffer());
        fileChannel.force(true);
    }

    public long getStoreTxLogRecordId() {
        return this.storeTxLogRecordId;
    }

    public void setStoreTxLogRecordId(long storeTxLogRecordId) {
        this.storeTxLogRecordId = storeTxLogRecordId;
    }
}

