/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.data;

import com.github.ltsopensource.kv.AbstractFileHeader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;

public class DataBlockFileHeader
extends AbstractFileHeader {
    private static final short magic = -16895;
    private long fileLength;
    private AtomicInteger totalNum = new AtomicInteger(0);
    private AtomicInteger aliveNum = new AtomicInteger(0);
    private int isFull;
    private long storeTxLogRecordId;

    @Override
    public int getLength() {
        return 30;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public AtomicInteger getTotalNum() {
        return this.totalNum;
    }

    public void setTotalNum(int totalNum) {
        this.totalNum.set(totalNum);
    }

    public AtomicInteger getAliveNum() {
        return this.aliveNum;
    }

    public void setAliveNum(int aliveNum) {
        this.aliveNum.set(aliveNum);
    }

    public boolean isFull() {
        return this.isFull == 1;
    }

    public void markFull() {
        this.isFull = 1;
    }

    public int getIsFull() {
        return this.isFull;
    }

    public void setIsFull(int isFull) {
        this.isFull = isFull;
    }

    public long getStoreTxLogRecordId() {
        return this.storeTxLogRecordId;
    }

    public void setStoreTxLogRecordId(long storeTxLogRecordId) {
        this.storeTxLogRecordId = storeTxLogRecordId;
    }

    @Override
    public void read(FileChannel fileChannel) throws IOException {
        fileChannel.position(0L);
        fileChannel.read(this.byteBuffer());
        this.byteBuffer().position(0);
        short readMagic = this.byteBuffer().getShort();
        if (readMagic != -16895) {
            throw new IOException("Invalid file type magic number 0x" + Integer.toHexString(readMagic & 0xFFFF));
        }
        this.fileLength = this.byteBuffer().getLong();
        this.totalNum.set(this.byteBuffer().getInt());
        this.aliveNum.set(this.byteBuffer().getInt());
        this.isFull = this.byteBuffer().getInt();
        this.storeTxLogRecordId = this.byteBuffer().getLong();
    }

    @Override
    public void write(FileChannel fileChannel) throws IOException {
        this.byteBuffer().position(0);
        this.byteBuffer().putShort((short)-16895);
        this.byteBuffer().putLong(this.fileLength);
        this.byteBuffer().putInt(this.totalNum.get());
        this.byteBuffer().putInt(this.aliveNum.get());
        this.byteBuffer().putInt(this.isFull);
        this.byteBuffer().putLong(this.storeTxLogRecordId);
        this.byteBuffer().flip();
        fileChannel.position(0L);
        fileChannel.write(this.byteBuffer());
        fileChannel.force(true);
    }
}

