/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.cache;

import com.github.ltsopensource.core.commons.utils.LRUCache;
import com.github.ltsopensource.kv.cache.DataCache;
import java.util.Collections;
import java.util.Map;

public class LRUDataCache<K, V>
implements DataCache<K, V> {
    private Map<K, V> cache;

    public LRUDataCache(int maxCacheSize) {
        this.cache = Collections.synchronizedMap(new LRUCache(maxCacheSize));
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public V remove(K key) {
        return this.cache.remove(key);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

