/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.DBException;
import com.github.ltsopensource.kv.Entry;
import com.github.ltsopensource.kv.Operation;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.cache.DataCache;
import com.github.ltsopensource.kv.cache.LRUDataCache;
import com.github.ltsopensource.kv.data.DataAppendResult;
import com.github.ltsopensource.kv.data.DataBlockEngine;
import com.github.ltsopensource.kv.index.Index;
import com.github.ltsopensource.kv.index.IndexItem;
import com.github.ltsopensource.kv.index.IndexSnapshot;
import com.github.ltsopensource.kv.index.IndexType;
import com.github.ltsopensource.kv.index.MemIndex;
import com.github.ltsopensource.kv.index.MemIndexSnapshot;
import com.github.ltsopensource.kv.iterator.DBIterator;
import com.github.ltsopensource.kv.replay.TxLogReplay;
import com.github.ltsopensource.kv.serializer.StoreSerializer;
import com.github.ltsopensource.kv.txlog.StoreTxLogEngine;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;
import java.io.Closeable;

public class DBImpl<K, V>
implements DB<K, V>,
Closeable {
    private StoreTxLogEngine<K, V> storeTxLogEngine;
    private DataBlockEngine<K, V> dataBlockEngine;
    private StoreConfig storeConfig;
    private Index<K, V> index;
    private DataCache<K, V> dataCache;
    private IndexSnapshot<K, V> indexSnapshot;
    private TxLogReplay<K, V> txLogReplay;

    public DBImpl(StoreSerializer serializer, StoreConfig storeConfig) {
        this.storeConfig = storeConfig;
        this.dataCache = new LRUDataCache(storeConfig.getMaxDataCacheSize());
        this.storeTxLogEngine = new StoreTxLogEngine(serializer, storeConfig);
        this.dataBlockEngine = new DataBlockEngine(serializer, storeConfig);
        if (IndexType.MEM != storeConfig.getIndexType()) {
            throw new IllegalArgumentException("Illegal IndexEngine " + (Object)((Object)storeConfig.getIndexType()));
        }
        this.index = new MemIndex<K, V>(storeConfig, this.dataBlockEngine, this.dataCache);
        this.txLogReplay = new TxLogReplay<K, V>(this.storeTxLogEngine, this.dataBlockEngine, this.index, this.dataCache);
        this.indexSnapshot = new MemIndexSnapshot<K, V>(this.txLogReplay, this.index, storeConfig, serializer);
    }

    @Override
    public void init() throws DBException {
        try {
            FileUtils.createDirIfNotExist(this.storeConfig.getDbPath());
            this.storeTxLogEngine.init();
            this.dataBlockEngine.init();
            this.indexSnapshot.init();
        }
        catch (Exception e) {
            throw new DBException("DB init error:" + e.getMessage(), e);
        }
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public boolean containsKey(K key) {
        return this.index.containsKey(key);
    }

    @Override
    public V get(K key) {
        V value = this.dataCache.get(key);
        if (value != null) {
            return value;
        }
        IndexItem<K> indexItem = this.index.getIndexItem(key);
        if (indexItem == null) {
            return null;
        }
        return this.dataBlockEngine.getValue(indexItem);
    }

    @Override
    public void put(K key, V value) {
        StoreTxLogPosition storeTxLogPosition = this.storeTxLogEngine.append(Operation.PUT, key, value);
        DataAppendResult dataAppendResult = this.dataBlockEngine.append(storeTxLogPosition, key, value);
        this.index.putIndexItem(storeTxLogPosition, key, DBImpl.convertToIndex(key, dataAppendResult));
        this.dataCache.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.dataCache.remove(key);
        StoreTxLogPosition storeTxLogPosition = this.storeTxLogEngine.append(Operation.REMOVE, key);
        IndexItem<K> indexItem = this.index.removeIndexItem(storeTxLogPosition, key);
        if (indexItem != null) {
            this.dataBlockEngine.remove(storeTxLogPosition, indexItem);
        }
    }

    @Override
    public DBIterator<Entry<K, V>> iterator() {
        return this.index.iterator();
    }

    @Override
    public void close() {
        this.dataCache.clear();
    }

    public static <K> IndexItem<K> convertToIndex(K key, DataAppendResult result) {
        IndexItem<K> index = new IndexItem<K>();
        index.setKey(key);
        index.setFileId(result.getFileId());
        index.setFromIndex(result.getFromIndex());
        index.setLength(result.getLength());
        return index;
    }
}

