/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jvmmonitor;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.jvmmonitor.ReferenceCount;
import com.github.ltsopensource.jvmmonitor.mbean.JVMGC;
import com.github.ltsopensource.jvmmonitor.mbean.JVMInfo;
import com.github.ltsopensource.jvmmonitor.mbean.JVMMemory;
import com.github.ltsopensource.jvmmonitor.mbean.JVMThread;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JVMMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JVMMonitor.class);
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final AtomicBoolean start = new AtomicBoolean(false);
    private static final ReferenceCount REF_COUNT = JVMMonitor.getRefCount();
    private static final Map<String, Object> MONITOR_MAP = new HashMap<String, Object>();

    public static void start() {
        REF_COUNT.incrementAndGet();
        if (start.compareAndSet(false, true)) {
            if (CollectionUtils.isEmpty(MONITOR_MAP)) {
                MONITOR_MAP.put("com.github.ltsopensource.jvmmonitor:type=JVMInfo", JVMInfo.getInstance());
                MONITOR_MAP.put("com.github.ltsopensource.jvmmonitor:type=JVMMemory", JVMMemory.getInstance());
                MONITOR_MAP.put("com.github.ltsopensource.jvmmonitor:type=JVMGC", JVMGC.getInstance());
                MONITOR_MAP.put("com.github.ltsopensource.jvmmonitor:type=JVMThread", JVMThread.getInstance());
            }
            try {
                for (Map.Entry<String, Object> entry : MONITOR_MAP.entrySet()) {
                    ObjectName objectName = new ObjectName(entry.getKey());
                    if (MBEAN_SERVER.isRegistered(objectName)) continue;
                    MBEAN_SERVER.registerMBean(entry.getValue(), objectName);
                }
                LOGGER.info("Start JVMMonitor succeed ");
            }
            catch (Exception e) {
                LOGGER.error("Start JVMMonitor error ", e);
            }
        }
    }

    public static void stop() {
        REF_COUNT.decrementAndGet();
        if (start.compareAndSet(true, false) && REF_COUNT.getCurRefCount() == 0L) {
            for (Map.Entry<String, Object> entry : MONITOR_MAP.entrySet()) {
                try {
                    ObjectName objectName = new ObjectName(entry.getKey());
                    if (!MBEAN_SERVER.isRegistered(objectName)) continue;
                    MBEAN_SERVER.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    LOGGER.error("Stop JVMMonitor {} error", entry.getKey(), e);
                }
            }
            LOGGER.info("Stop JVMMonitor succeed ");
        }
    }

    public static Map<String, Object> getAttribute(String objectName, List<String> attributeNames) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            for (String attributeName : attributeNames) {
                try {
                    Object value = MBEAN_SERVER.getAttribute(new ObjectName(objectName), attributeName);
                    result.put(attributeName, value);
                }
                catch (Exception ignored) {}
            }
        }
        catch (Exception e) {
            LOGGER.error("get Attribute error, objectName=" + objectName + ", attributeName=" + attributeNames, e);
        }
        return result;
    }

    public static Object getAttribute(String objectName, String attributeName) {
        try {
            return MBEAN_SERVER.getAttribute(new ObjectName(objectName), attributeName);
        }
        catch (Exception e) {
            LOGGER.error("get Attribute error, objectName=" + objectName + ", attributeName=" + attributeName, e);
            return null;
        }
    }

    private static ReferenceCount getRefCount() {
        try {
            return (ReferenceCount)JVMMonitor.loadClass("com.github.ltsopensource.jvmmonitor.JVMMonitorReferenceCount").newInstance();
        }
        catch (Throwable e) {
            LOGGER.warn("load com.github.ltsopensource.jvmmonitor.JVMMonitorReferenceCount error", e);
            return new ReferenceCount(){
                private final AtomicLong count = new AtomicLong(0L);

                @Override
                public long incrementAndGet() {
                    return this.count.incrementAndGet();
                }

                @Override
                public long decrementAndGet() {
                    return this.count.decrementAndGet();
                }

                @Override
                public long getCurRefCount() {
                    return this.count.get();
                }
            };
        }
    }

    private static Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JVMMonitor.class.getClassLoader();
        }
        return classLoader.loadClass(classname);
    }
}

