/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json;

import com.github.ltsopensource.json.deserializer.ArrayDeserializer;
import com.github.ltsopensource.json.deserializer.CollectionDeserializer;
import com.github.ltsopensource.json.deserializer.Deserializer;
import com.github.ltsopensource.json.deserializer.EnumDeserializer;
import com.github.ltsopensource.json.deserializer.JavaBeanDeserializer;
import com.github.ltsopensource.json.deserializer.MapDeserializer;
import com.github.ltsopensource.json.deserializer.PrimitiveTypeDeserializer;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JSONParser {
    protected static final ConcurrentMap<Type, Deserializer> deserializerMap = new ConcurrentHashMap<Type, Deserializer>();
    private static final Set<Class<?>> primitiveClasses = new HashSet();

    public static <T> T parse(Object object, Type type) {
        Deserializer deserializer = JSONParser.getDeserializer(type);
        return deserializer.deserialize(object, type);
    }

    public static Deserializer getDeserializer(Type type) {
        Deserializer deserializer = (Deserializer)deserializerMap.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type instanceof Class) {
            return JSONParser.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return JSONParser.getDeserializer((Class)rawType, type);
            }
            return JSONParser.getDeserializer(rawType);
        }
        if (type instanceof GenericArrayType) {
            return ArrayDeserializer.INSTANCE;
        }
        throw new IllegalArgumentException("can't get the Deserializer by " + type);
    }

    private static Deserializer getDeserializer(Class<?> clazz, Type type) {
        Deserializer deserializer = JSONParser.isPrimitiveClasses(clazz) ? new PrimitiveTypeDeserializer() : (clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ArrayDeserializer.INSTANCE : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionDeserializer.INSTANCE : (Collection.class.isAssignableFrom(clazz) ? CollectionDeserializer.INSTANCE : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.INSTANCE : new JavaBeanDeserializer(clazz))))));
        deserializerMap.put(type, deserializer);
        return deserializer;
    }

    public static boolean isPrimitiveClasses(Class<?> clazz) {
        return primitiveClasses.contains(clazz);
    }

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
    }
}

