/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.support.bean;

import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.BeanUtils;
import com.github.ltsopensource.core.commons.utils.ClassHelper;
import com.github.ltsopensource.core.commons.utils.ReflectionUtils;
import com.github.ltsopensource.core.exception.LtsRuntimeException;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.bean.BeanCopier;
import com.github.ltsopensource.core.support.bean.JavaSourceBean;
import com.github.ltsopensource.core.support.bean.JdkCompiler;
import com.github.ltsopensource.core.support.bean.PropConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class BeanCopierFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCopierFactory.class);
    private static final JdkCompiler JDK_COMPILER = new JdkCompiler();
    private static final AtomicInteger SEQ = new AtomicInteger(0);
    private static final ConcurrentMap<Integer, Map<String, PropConverter<?, ?>>> SEQ_PROP_CVT_MAP = new ConcurrentHashMap();

    public static <Source, Target> BeanCopier<Source, Target> createCopier(Class<?> sourceClass, Class<?> targetClass) {
        return BeanCopierFactory.createCopier(sourceClass, targetClass, false, null);
    }

    public static <Source, Target> BeanCopier<Source, Target> createCopier(Class<?> sourceClass, Class<?> targetClass, boolean deepCopy) {
        return BeanCopierFactory.createCopier(sourceClass, targetClass, deepCopy, null);
    }

    public static <Source, Target> BeanCopier<Source, Target> createCopier(Class<?> sourceClass, Class<?> targetClass, Map<String, PropConverter<?, ?>> propCvtMap) {
        return BeanCopierFactory.createCopier(sourceClass, targetClass, false, propCvtMap);
    }

    public static <Source, Target> BeanCopier<Source, Target> createCopier(Class<?> sourceClass, Class<?> targetClass, boolean deepCopy, Map<String, PropConverter<?, ?>> propCvtMap) {
        Assert.notNull(sourceClass, "sourceClass can't be null");
        Assert.notNull(targetClass, "targetClass can't be null");
        Integer sequence = SEQ.incrementAndGet();
        if (propCvtMap != null) {
            SEQ_PROP_CVT_MAP.putIfAbsent(sequence, propCvtMap);
        }
        try {
            Class<?> beanCopierClazz = JDK_COMPILER.compile(BeanCopierFactory.getClassCode(sequence, sourceClass, targetClass, deepCopy, propCvtMap));
            return (BeanCopier)beanCopierClazz.newInstance();
        }
        catch (Exception e) {
            throw new LtsRuntimeException("Generate BeanCopier error, sourceClass=" + sourceClass.getName() + ", targetClass=" + targetClass.getName(), e);
        }
    }

    private static String getClassCode(Integer sequence, Class<?> sourceClass, Class<?> targetClass, boolean deepCopy, Map<String, PropConverter<?, ?>> propCvtMap) throws Exception {
        JavaSourceBean javaSourceBean = new JavaSourceBean();
        javaSourceBean.setPackageName(BeanCopierFactory.class.getPackage().getName());
        javaSourceBean.addImport(BeanCopier.class.getName());
        javaSourceBean.addImport(sourceClass.getName());
        javaSourceBean.addImport(targetClass.getName());
        String beanCopierClassName = sourceClass.getSimpleName() + "2" + targetClass.getSimpleName() + BeanCopier.class.getSimpleName() + sequence;
        String classDefinitionCode = "public class " + beanCopierClassName + " implements " + BeanCopier.class.getSimpleName() + "<" + sourceClass.getSimpleName() + "," + targetClass.getSimpleName() + ">";
        javaSourceBean.setClassDefinition(classDefinitionCode);
        javaSourceBean.addMethod(BeanCopierFactory.getMethodImplCode(sequence, sourceClass, targetClass, deepCopy, propCvtMap));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(javaSourceBean.toString());
        }
        return javaSourceBean.toString();
    }

    private static String getMethodImplCode(Integer sequence, Class<?> sourceClass, Class<?> targetClass, boolean deepCopy, Map<String, PropConverter<?, ?>> propCvtMap) throws Exception {
        Field[] targetFields;
        StringBuilder methodCode = new StringBuilder();
        methodCode.append("public void copyProps(").append(sourceClass.getSimpleName()).append(" source, ").append(targetClass.getSimpleName()).append(" target){\n");
        for (Field field : targetFields = ReflectionUtils.findFields(targetClass)) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String methodNameSuffix = BeanCopierFactory.capitalize(field.getName());
            Class<?> targetFieldClass = field.getType();
            Type targetFieldType = field.getGenericType();
            Method setMethod = ReflectionUtils.findMethod(targetClass, "set" + methodNameSuffix, targetFieldClass);
            if (setMethod == null) continue;
            if (propCvtMap != null && propCvtMap.containsKey(field.getName())) {
                String converterName = field.getName() + "Converter";
                String converterType = PropConverter.class.getName() + "<" + sourceClass.getSimpleName() + ", " + targetFieldType.toString() + "> ";
                methodCode.append(converterType).append(converterName).append(" = (").append(converterType).append(")").append(BeanCopierFactory.class.getName()).append(".getConverter(").append(sequence).append(",").append("\"").append(field.getName()).append("\");\n");
                methodCode.append("target.").append(setMethod.getName()).append("(").append("(").append(targetFieldType.toString()).append(")").append(converterName).append(".convert(").append("source").append(")").append(");\n");
                continue;
            }
            Method getMethod = ReflectionUtils.findMethod(sourceClass, "get" + methodNameSuffix);
            if (getMethod == null && (targetFieldClass == Boolean.TYPE || targetFieldClass == Boolean.class)) {
                getMethod = ReflectionUtils.findMethod(sourceClass, "is" + methodNameSuffix);
            }
            if (getMethod == null) continue;
            if (getMethod.getReturnType() == targetFieldClass) {
                if (!deepCopy) {
                    methodCode.append("target.").append(setMethod.getName()).append("(").append("source.").append(getMethod.getName()).append("()").append(");\n");
                    continue;
                }
                if (ClassHelper.isPrimitiveType(targetFieldClass) || ClassHelper.isPrimitiveWrapperType(targetFieldClass) || targetFieldClass == String.class) {
                    methodCode.append("target.").append(setMethod.getName()).append("(").append("source.").append(getMethod.getName()).append("()").append(");\n");
                    continue;
                }
                methodCode.append("target.").append(setMethod.getName()).append("(").append("(").append(targetFieldType.toString()).append(")").append(BeanUtils.class.getName()).append(".deepClone(").append("source.").append(getMethod.getName()).append("()").append(")").append(");\n");
                continue;
            }
            if (ClassHelper.isPrimitiveType(targetFieldClass) && ClassHelper.getPrimitiveTypeByWrapper(getMethod.getReturnType()) == targetFieldClass) {
                methodCode.append("target.").append(setMethod.getName()).append("(");
                methodCode.append("source.").append(getMethod.getName()).append("() == null ? ").append(String.valueOf(ClassHelper.getPrimitiveDftValue(targetFieldClass))).append(" : ").append("source.").append(getMethod.getName()).append("()");
                methodCode.append(");\n");
                continue;
            }
            if (!ClassHelper.isPrimitiveWrapperType(targetFieldClass) || ClassHelper.getWrapperTypeByPrimitive(getMethod.getReturnType()) != targetFieldClass) continue;
            methodCode.append("target.").append(setMethod.getName()).append("(").append("source.").append(getMethod.getName()).append("()").append(");\n");
        }
        methodCode.append("}");
        return methodCode.toString();
    }

    private static String capitalize(String str) {
        return String.valueOf(Character.toTitleCase(str.charAt(0))) + str.substring(1);
    }

    public static PropConverter<?, ?> getConverter(Integer sequence, String propName) {
        Map map = (Map)SEQ_PROP_CVT_MAP.get(sequence);
        return (PropConverter)map.get(propName);
    }
}

