/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.support;

import com.github.ltsopensource.core.commons.utils.BeanUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.core.support.bean.BeanCopier;
import com.github.ltsopensource.core.support.bean.BeanCopierFactory;
import com.github.ltsopensource.core.support.bean.PropConverter;
import com.github.ltsopensource.queue.domain.JobPo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JobUtils {
    private static final BeanCopier<Job, Job> JOB_BEAN_COPIER;
    private static final BeanCopier<JobPo, JobPo> JOB_PO_BEAN_COPIER;

    public static long getRepeatNextTriggerTime(JobPo jobPo) {
        long firstTriggerTime = Long.valueOf(jobPo.getInternalExtParam("__LTS_Repeat_Job_First_Fire_Time"));
        long now = SystemClock.now();
        long remainder = (now - firstTriggerTime) % jobPo.getRepeatInterval();
        if (remainder == 0L) {
            return now;
        }
        return now + (jobPo.getRepeatInterval() - remainder);
    }

    public static boolean isRelyOnPrevCycle(JobPo jobPo) {
        return jobPo.getRelyOnPrevCycle() == null || jobPo.getRelyOnPrevCycle() != false;
    }

    public static String generateJobId() {
        return StringUtils.generateUUID();
    }

    public static Job copy(Job source) {
        Job job = new Job();
        JOB_BEAN_COPIER.copyProps(source, job);
        return job;
    }

    public static JobPo copy(JobPo source) {
        JobPo jobPo = new JobPo();
        JOB_PO_BEAN_COPIER.copyProps(source, jobPo);
        return jobPo;
    }

    static {
        ConcurrentHashMap jobPoConverterMap = new ConcurrentHashMap(1);
        jobPoConverterMap.put("extParams", new PropConverter<JobPo, Map<String, String>>(){

            @Override
            public Map<String, String> convert(JobPo jobPo) {
                return BeanUtils.copyMap(jobPo.getExtParams());
            }
        });
        jobPoConverterMap.put("internalExtParams", new PropConverter<JobPo, Map<String, String>>(){

            @Override
            public Map<String, String> convert(JobPo jobPo) {
                return BeanUtils.copyMap(jobPo.getInternalExtParams());
            }
        });
        JOB_PO_BEAN_COPIER = BeanCopierFactory.createCopier(JobPo.class, JobPo.class, jobPoConverterMap);
        ConcurrentHashMap jobConverterMap = new ConcurrentHashMap(1);
        jobConverterMap.put("extParams", new PropConverter<Job, Map<String, String>>(){

            @Override
            public Map<String, String> convert(Job job) {
                return BeanUtils.copyMap(job.getExtParams());
            }
        });
        JOB_BEAN_COPIER = BeanCopierFactory.createCopier(Job.class, Job.class, jobConverterMap);
    }
}

