/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.support;

import com.github.ltsopensource.core.exception.CronException;
import com.github.ltsopensource.core.support.CronExpression;
import java.text.ParseException;
import java.util.Date;

public class CronExpressionUtils {
    private CronExpressionUtils() {
    }

    public static Date getNextTriggerTime(String cronExpression) {
        try {
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getTimeAfter(new Date());
        }
        catch (ParseException e) {
            throw new CronException(e);
        }
    }

    public static Date getNextTriggerTime(String cronExpression, Date timeAfter) {
        try {
            CronExpression cron = new CronExpression(cronExpression);
            if (timeAfter == null) {
                timeAfter = new Date();
            }
            return cron.getTimeAfter(timeAfter);
        }
        catch (ParseException e) {
            throw new CronException(e);
        }
    }

    public static boolean isValidExpression(String cronExpression) {
        return CronExpression.isValidExpression(cronExpression);
    }
}

