/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.spi;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.spi.ClassLoaderUtil;
import com.github.ltsopensource.core.spi.SPI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoader.class);
    private static final String LTS_DIRECTORY = "META-INF/lts/";
    private static final String LTS_INTERNAL = "internal";
    private static final String LTS_INTERNAL_DIRECTORY = "META-INF/lts/internal/";
    private static final String DEFAULT_IDENTITY = StringUtils.generateUUID();
    private static final ConcurrentMap<Class<?>, ServiceProvider> serviceMap = new ConcurrentHashMap();
    private static final ConcurrentMap<IdentityUniqueKey, Object> cachedObjectMap = new ConcurrentHashMap<IdentityUniqueKey, Object>();

    public static <T> T load(Class<T> clazz, Config config) {
        ServiceProvider serviceProvider = ServiceLoader.getServiceProvider(clazz);
        String dynamicServiceName = config.getParameter(serviceProvider.dynamicConfigKey);
        String identity = config.getIdentity();
        return ServiceLoader.load(clazz, dynamicServiceName, identity);
    }

    public static <T> T load(Class<T> clazz, Config config, String configKey) {
        String dynamicServiceName = config.getParameter(configKey);
        String identity = config.getIdentity();
        return ServiceLoader.load(clazz, dynamicServiceName, identity);
    }

    public static <T> T loadDefault(Class<T> clazz) {
        return ServiceLoader.load(clazz, "");
    }

    public static <T> T load(Class<T> clazz, String name) {
        return ServiceLoader.load(clazz, name, DEFAULT_IDENTITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Class<T> clazz, String name, String identity) {
        try {
            ServiceDefinition definition;
            ServiceProvider serviceProvider = ServiceLoader.getServiceProvider(clazz);
            if (StringUtils.isEmpty(name)) {
                name = serviceProvider.defaultName;
            }
            if ((definition = (ServiceDefinition)serviceProvider.nameMaps.get(name)) == null) {
                throw new IllegalStateException("Service loader could not load name:" + name + "  class:" + clazz.getName() + "'s ServiceProvider from '" + LTS_DIRECTORY + "' or '" + LTS_INTERNAL_DIRECTORY + "' It may be empty or does not exist.");
            }
            IdentityUniqueKey uniqueKey = new IdentityUniqueKey(identity, definition);
            Object obj = cachedObjectMap.get(uniqueKey);
            if (obj != null) {
                return (T)obj;
            }
            ServiceDefinition serviceDefinition = definition;
            synchronized (serviceDefinition) {
                obj = cachedObjectMap.get(uniqueKey);
                if (obj != null) {
                    return (T)obj;
                }
                String className = definition.clazz;
                ClassLoader classLoader = definition.classLoader;
                T srv = clazz.cast(ClassLoaderUtil.newInstance(classLoader, className));
                cachedObjectMap.putIfAbsent(uniqueKey, srv);
                return srv;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Service loader could not load name:" + name + "  class:" + clazz.getName() + "'s ServiceProvider from '" + LTS_DIRECTORY + "' or '" + LTS_INTERNAL_DIRECTORY + "' It may be empty or does not exist.");
        }
    }

    private static ServiceProvider getServiceProvider(Class<?> clazz) {
        ServiceProvider serviceProvider = (ServiceProvider)serviceMap.get(clazz);
        if (serviceProvider == null) {
            ServiceLoader.getServiceProviders(clazz);
            serviceProvider = (ServiceProvider)serviceMap.get(clazz);
        }
        return serviceProvider;
    }

    public static Set<String> getServiceProviders(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(" type(" + clazz + ") is not interface!");
        }
        if (!clazz.isAnnotationPresent(SPI.class)) {
            throw new IllegalArgumentException("type(" + clazz + ") is not extension, because WITHOUT @" + SPI.class.getSimpleName() + " Annotation!");
        }
        SPI spi = clazz.getAnnotation(SPI.class);
        String defaultName = spi.dftValue();
        String dynamicConfigKey = spi.key();
        HashSet<URLDefinition> urlDefinitions = new HashSet<URLDefinition>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        urlDefinitions.addAll(ServiceLoader.collectExtensionUrls(LTS_DIRECTORY + clazz.getName(), classLoader));
        urlDefinitions.addAll(ServiceLoader.collectExtensionUrls(LTS_INTERNAL_DIRECTORY + clazz.getName(), classLoader));
        ConcurrentHashMap<String, ServiceDefinition> serviceDefinitions = new ConcurrentHashMap<String, ServiceDefinition>();
        for (URLDefinition urlDefinition : urlDefinitions) {
            serviceDefinitions.putAll(ServiceLoader.parse(urlDefinition));
        }
        if (serviceDefinitions.isEmpty()) {
            throw new IllegalStateException("Service loader could not load " + clazz.getName() + "'s ServiceProvider from '" + LTS_DIRECTORY + "' or '" + LTS_INTERNAL_DIRECTORY + "' It may be empty or does not exist.");
        }
        ServiceProvider serviceProvider = new ServiceProvider(clazz, dynamicConfigKey, defaultName, serviceDefinitions);
        serviceMap.remove(clazz);
        serviceMap.put(clazz, serviceProvider);
        return serviceDefinitions.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ServiceDefinition> parse(URLDefinition urlDefinition) {
        HashMap<String, ServiceDefinition> nameClassMap = new HashMap<String, ServiceDefinition>();
        try {
            BufferedReader r = null;
            try {
                String line;
                URL url = urlDefinition.uri.toURL();
                r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = r.readLine()) != null) {
                    int i;
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((line = line.trim()).length() == 0 || (i = line.indexOf(61)) <= 0) continue;
                    String name = line.substring(0, i).trim();
                    String clazz = line.substring(i + 1).trim();
                    nameClassMap.put(name, new ServiceDefinition(name, clazz, urlDefinition.classLoader));
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("parse " + urlDefinition.uri + " error:" + e.getMessage(), e);
        }
        return nameClassMap;
    }

    private static Set<URLDefinition> collectExtensionUrls(String resourceName, ClassLoader classLoader) {
        try {
            Enumeration<URL> configs = classLoader != null ? classLoader.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
            HashSet<URLDefinition> urlDefinitions = new HashSet<URLDefinition>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                URI uri = url.toURI();
                ClassLoader highestClassLoader = ServiceLoader.findHighestReachableClassLoader(url, classLoader, resourceName);
                urlDefinitions.add(new URLDefinition(uri, highestClassLoader));
            }
            return urlDefinitions;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return Collections.emptySet();
        }
    }

    private static ClassLoader findHighestReachableClassLoader(URL url, ClassLoader classLoader, String resourceName) {
        if (classLoader.getParent() == null) {
            return classLoader;
        }
        ClassLoader highestClassLoader = classLoader;
        ClassLoader current = classLoader;
        while (current.getParent() != null) {
            ClassLoader parent = current.getParent();
            try {
                Enumeration<URL> resources = parent.getResources(resourceName);
                if (resources != null) {
                    while (resources.hasMoreElements()) {
                        URL resourceURL = resources.nextElement();
                        if (!url.toURI().equals(resourceURL.toURI())) continue;
                        highestClassLoader = parent;
                    }
                }
            }
            catch (IOException ignore) {
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
            current = current.getParent();
        }
        return highestClassLoader;
    }

    private static final class ServiceProvider {
        private final Class<?> clazz;
        private final String defaultName;
        private final String dynamicConfigKey;
        private final ConcurrentMap<String, ServiceDefinition> nameMaps;

        public ServiceProvider(Class<?> clazz, String dynamicConfigKey, String defaultName, ConcurrentMap<String, ServiceDefinition> nameMaps) {
            this.clazz = clazz;
            this.dynamicConfigKey = dynamicConfigKey;
            this.defaultName = defaultName;
            this.nameMaps = nameMaps;
        }
    }

    private static class IdentityUniqueKey {
        private String identity;
        private ServiceDefinition definition;

        public IdentityUniqueKey(String identity, ServiceDefinition definition) {
            this.identity = identity;
            this.definition = definition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityUniqueKey that = (IdentityUniqueKey)o;
            if (this.identity != null ? !this.identity.equals(that.identity) : that.identity != null) {
                return false;
            }
            return this.definition != null ? this.definition.equals(that.definition) : that.definition == null;
        }

        public int hashCode() {
            int result = this.identity != null ? this.identity.hashCode() : 0;
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            return result;
        }
    }

    private static final class ServiceDefinition {
        private final String name;
        private final String clazz;
        private final ClassLoader classLoader;

        private ServiceDefinition(String name, String clazz, ClassLoader classLoader) {
            Assert.notNull(name, "name");
            Assert.notNull(clazz, "clazz");
            Assert.notNull(classLoader, "classLoader");
            this.name = name;
            this.clazz = clazz;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceDefinition that = (ServiceDefinition)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null) {
                return false;
            }
            return this.classLoader != null ? this.classLoader.equals(that.classLoader) : that.classLoader == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
            return result;
        }
    }

    private static final class URLDefinition {
        private final URI uri;
        private final ClassLoader classLoader;

        private URLDefinition(URI url, ClassLoader classLoader) {
            this.uri = url;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URLDefinition that = (URLDefinition)o;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        public int hashCode() {
            return this.uri != null ? this.uri.hashCode() : 0;
        }
    }
}

