/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry.zookeeper;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.registry.FailbackRegistry;
import com.github.ltsopensource.core.registry.NodeRegistryUtils;
import com.github.ltsopensource.core.registry.NotifyEvent;
import com.github.ltsopensource.core.registry.NotifyListener;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.zookeeper.ChildListener;
import com.github.ltsopensource.zookeeper.StateListener;
import com.github.ltsopensource.zookeeper.ZkClient;
import com.github.ltsopensource.zookeeper.ZookeeperTransporter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ZookeeperRegistry
extends FailbackRegistry {
    private ZkClient zkClient;
    private final ConcurrentHashMap<String, List<String>> cachedChildrenNodeMap;
    private final ConcurrentMap<Node, ConcurrentMap<NotifyListener, ChildListener>> zkListeners;
    private String clusterName;

    public ZookeeperRegistry(final AppContext appContext) {
        super(appContext);
        this.clusterName = appContext.getConfig().getClusterName();
        this.cachedChildrenNodeMap = new ConcurrentHashMap();
        ZookeeperTransporter zookeeperTransporter = ServiceLoader.load(ZookeeperTransporter.class, appContext.getConfig());
        this.zkClient = zookeeperTransporter.connect(appContext.getConfig());
        this.zkListeners = new ConcurrentHashMap<Node, ConcurrentMap<NotifyListener, ChildListener>>();
        appContext.getRegistryStatMonitor().setAvailable(true);
        this.zkClient.addStateListener(new StateListener(){

            @Override
            public void stateChanged(int state) {
                if (state == 0) {
                    appContext.getRegistryStatMonitor().setAvailable(false);
                } else if (state == 1) {
                    appContext.getRegistryStatMonitor().setAvailable(true);
                } else if (state == 2) {
                    try {
                        appContext.getRegistryStatMonitor().setAvailable(true);
                        ZookeeperRegistry.this.recover();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                }
            }
        });
    }

    @Override
    protected void doRegister(Node node) {
        if (this.zkClient.exists(node.toFullString())) {
            return;
        }
        this.zkClient.create(node.toFullString(), true, false);
    }

    @Override
    protected void doUnRegister(Node node) {
        this.zkClient.delete(node.toFullString());
    }

    @Override
    protected void doSubscribe(Node node, NotifyListener listener) {
        List<NodeType> listenNodeTypes = node.getListenNodeTypes();
        if (CollectionUtils.isEmpty(listenNodeTypes)) {
            return;
        }
        for (NodeType listenNodeType : listenNodeTypes) {
            ChildListener zkListener;
            String listenNodePath = NodeRegistryUtils.getNodeTypePath(this.clusterName, listenNodeType);
            List<String> children = this.zkClient.addChildListener(listenNodePath, zkListener = this.addZkListener(node, listener));
            if (!CollectionUtils.isNotEmpty(children)) continue;
            ArrayList<Node> listenedNodes = new ArrayList<Node>();
            for (String child : children) {
                Node listenedNode = NodeRegistryUtils.parse(listenNodePath + "/" + child);
                listenedNodes.add(listenedNode);
            }
            this.notify(NotifyEvent.ADD, listenedNodes, listener);
            this.cachedChildrenNodeMap.put(listenNodePath, children);
        }
    }

    @Override
    protected void doUnsubscribe(Node node, NotifyListener listener) {
        ChildListener zkListener;
        ConcurrentMap listeners = (ConcurrentMap)this.zkListeners.get(node);
        if (listeners != null && (zkListener = (ChildListener)listeners.get(listener)) != null) {
            List<NodeType> listenNodeTypes = node.getListenNodeTypes();
            if (CollectionUtils.isEmpty(listenNodeTypes)) {
                return;
            }
            for (NodeType listenNodeType : listenNodeTypes) {
                String listenNodePath = NodeRegistryUtils.getNodeTypePath(this.clusterName, listenNodeType);
                this.zkClient.removeChildListener(listenNodePath, zkListener);
            }
        }
    }

    private ChildListener addZkListener(Node node, final NotifyListener listener) {
        ChildListener zkListener;
        ConcurrentMap listeners = (ConcurrentMap)this.zkListeners.get(node);
        if (listeners == null) {
            this.zkListeners.putIfAbsent(node, new ConcurrentHashMap());
            listeners = (ConcurrentMap)this.zkListeners.get(node);
        }
        if ((zkListener = (ChildListener)listeners.get(listener)) == null) {
            listeners.putIfAbsent(listener, new ChildListener(){

                @Override
                public void childChanged(String parentPath, List<String> currentChildren) {
                    Node node;
                    ArrayList<Node> nodes;
                    if (CollectionUtils.isEmpty(currentChildren)) {
                        currentChildren = new ArrayList<String>(0);
                    }
                    List oldChildren = (List)ZookeeperRegistry.this.cachedChildrenNodeMap.get(parentPath);
                    List<String> addChildren = CollectionUtils.getLeftDiff(currentChildren, oldChildren);
                    List<String> decChildren = CollectionUtils.getLeftDiff(oldChildren, currentChildren);
                    if (CollectionUtils.isNotEmpty(addChildren)) {
                        nodes = new ArrayList<Node>(addChildren.size());
                        for (String child : addChildren) {
                            node = NodeRegistryUtils.parse(parentPath + "/" + child);
                            nodes.add(node);
                        }
                        ZookeeperRegistry.this.notify(NotifyEvent.ADD, nodes, listener);
                    }
                    if (CollectionUtils.isNotEmpty(decChildren)) {
                        nodes = new ArrayList(addChildren.size());
                        for (String child : decChildren) {
                            node = NodeRegistryUtils.parse(parentPath + "/" + child);
                            nodes.add(node);
                        }
                        ZookeeperRegistry.this.notify(NotifyEvent.REMOVE, nodes, listener);
                    }
                    ZookeeperRegistry.this.cachedChildrenNodeMap.put(parentPath, currentChildren);
                }
            });
            zkListener = (ChildListener)listeners.get(listener);
        }
        return zkListener;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.zkClient.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close zookeeper client " + this.getNode() + ", cause: " + e.getMessage(), e);
        }
    }
}

