/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.monitor;

import com.github.ltsopensource.cmd.DefaultHttpCmd;
import com.github.ltsopensource.cmd.HttpCmd;
import com.github.ltsopensource.cmd.HttpCmdClient;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.BatchUtils;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.domain.monitor.MNode;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.loadbalance.LoadBalance;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.monitor.AbstractMStatReporter;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jvmmonitor.JVMCollector;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class MStatReportWorker
implements Runnable {
    protected final Logger LOGGER = LoggerFactory.getLogger(MStatReportWorker.class);
    private int interval = 1;
    private Integer preMinute = null;
    private AppContext appContext;
    private AbstractMStatReporter reporter;
    private List<MData> mDataQueue = new ArrayList<MData>();
    private static final int MAX_RETRY_RETAIN = 500;
    private static final int BATCH_REPORT_SIZE = 10;
    private volatile boolean running = false;
    private LoadBalance loadBalance;

    public MStatReportWorker(AppContext appContext, AbstractMStatReporter reporter) {
        this.appContext = appContext;
        this.reporter = reporter;
        this.interval = appContext.getConfig().getParameter("lts.monitor.report.interval", 1);
        this.loadBalance = ServiceLoader.load(LoadBalance.class, appContext.getConfig(), "monitor.select.loadbalance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            if (this.running) {
                return;
            }
            this.running = true;
            try {
                Calendar calendar = Calendar.getInstance();
                int minute = calendar.get(12);
                if (this.preMinute == null) {
                    this.preMinute = minute;
                    return;
                }
                int diff = minute - this.preMinute;
                int n = diff = diff < 0 ? diff + 60 : diff;
                if (diff == 0 || diff % this.interval != 0) break block11;
                try {
                    MData mData = this.reporter.collectMData();
                    long seconds = SystemClock.now() / 1000L;
                    seconds -= seconds % 60L;
                    mData.setTimestamp((seconds -= (long)(this.interval * 60)) * 1000L);
                    mData.setJvmMData(JVMCollector.collect());
                    this.report(mData);
                }
                finally {
                    this.preMinute = minute;
                }
            }
            catch (Throwable t) {
                this.LOGGER.error("MStatReportWorker collect failed.", t);
            }
            finally {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(MData mData) {
        List<Node> monitorNodes;
        this.mDataQueue.add(mData);
        int size = this.mDataQueue.size();
        if (size > 500) {
            this.mDataQueue = this.mDataQueue.subList(size - 500, size);
        }
        if (CollectionUtils.isEmpty(monitorNodes = this.appContext.getSubscribedNodeManager().getNodeList(NodeType.MONITOR))) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Please Start LTS-Monitor");
            }
            return;
        }
        int toIndex = 0;
        size = this.mDataQueue.size();
        try {
            for (int i = 0; i <= size / 10; ++i) {
                List<MData> mDatas = BatchUtils.getBatchList(i, 10, this.mDataQueue);
                if (!CollectionUtils.isNotEmpty(mDatas)) continue;
                try {
                    DefaultHttpCmd cmd = new DefaultHttpCmd();
                    cmd.setCommand("monitor_data_add_cmd");
                    cmd.addParam("mNode", JSON.toJSONString(this.buildMNode()));
                    cmd.addParam("mData", JSON.toJSONString(mDatas));
                    if (this.sendReq(monitorNodes, cmd)) {
                        toIndex += CollectionUtils.sizeOf(mDatas);
                        continue;
                    }
                    break;
                }
                catch (Exception e) {
                    this.LOGGER.warn("Report monitor data Error : " + e.getMessage(), e);
                    break;
                }
            }
        }
        finally {
            if (toIndex != 0) {
                if (size == toIndex) {
                    this.mDataQueue.clear();
                } else {
                    this.mDataQueue = this.mDataQueue.subList(toIndex + 1, size);
                }
            }
        }
    }

    private boolean sendReq(List<Node> monitorNodes, HttpCmd cmd) {
        do {
            Node node = this.selectMNode(monitorNodes);
            try {
                cmd.setNodeIdentity(node.getIdentity());
                Object response = HttpCmdClient.doPost(node.getIp(), node.getPort(), cmd);
                if (((HttpCmdResponse)response).isSuccess()) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Report Monitor Data Success.");
                    }
                    return true;
                }
                this.LOGGER.warn("Report Monitor Data Failed: " + ((HttpCmdResponse)response).getMsg());
                monitorNodes.remove(node);
            }
            catch (Exception e) {
                this.LOGGER.warn("Report Monitor Data Error: " + e.getMessage(), e);
            }
        } while (monitorNodes.size() != 0);
        return false;
    }

    private Node selectMNode(List<Node> monitorNodes) {
        return this.loadBalance.select(monitorNodes, this.appContext.getConfig().getIdentity());
    }

    private MNode buildMNode() {
        MNode mNode = new MNode();
        mNode.setNodeType(this.reporter.getNodeType());
        mNode.setNodeGroup(this.appContext.getConfig().getNodeGroup());
        mNode.setIdentity(this.appContext.getConfig().getIdentity());
        return mNode;
    }
}

