/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.monitor;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.monitor.MStatReportWorker;
import com.github.ltsopensource.core.monitor.MStatReporter;
import com.github.ltsopensource.jvmmonitor.JVMMonitor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractMStatReporter
implements MStatReporter {
    protected final Logger LOGGER = LoggerFactory.getLogger(AbstractMStatReporter.class);
    protected AppContext appContext;
    protected Config config;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("LTS-Monitor-data-collector", true));
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean start = new AtomicBoolean(false);

    public AbstractMStatReporter(AppContext appContext) {
        this.appContext = appContext;
        this.config = appContext.getConfig();
    }

    @Override
    public final void start() {
        JVMMonitor.start();
        try {
            if (this.start.compareAndSet(false, true)) {
                this.scheduledFuture = this.executor.scheduleWithFixedDelay(new MStatReportWorker(this.appContext, this), 1L, 1L, TimeUnit.SECONDS);
                this.LOGGER.info("MStatReporter start succeed.");
            }
        }
        catch (Exception e) {
            this.LOGGER.error("MStatReporter start failed.", e);
        }
    }

    protected abstract MData collectMData();

    protected abstract NodeType getNodeType();

    @Override
    public final void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                this.scheduledFuture.cancel(true);
                this.executor.shutdown();
                JVMMonitor.stop();
                this.LOGGER.info("MStatReporter stop succeed.");
            }
        }
        catch (Exception e) {
            this.LOGGER.error("MStatReporter stop failed.", e);
        }
    }
}

