/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.failstore.mapdb;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.failstore.AbstractFailStore;
import com.github.ltsopensource.core.failstore.FailStoreException;
import com.github.ltsopensource.core.json.JSON;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapdbFailStore
extends AbstractFailStore {
    public static final String name = "mapdb";
    private DB db;
    private ConcurrentNavigableMap<String, String> map;

    public MapdbFailStore(File dbPath, boolean needLock) {
        super(dbPath, needLock);
    }

    @Override
    protected void init() throws FailStoreException {
        try {
            String dbName = this.dbPath.getPath() + "/lts.db";
            this.db = DBMaker.fileDB((File)new File(dbName)).closeOnJvmShutdown().encryptionEnable("lts").make();
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    public void open() throws FailStoreException {
        try {
            this.map = this.db.treeMap("lts");
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void put(String key, Object value) throws FailStoreException {
        try {
            String valueString = JSON.toJSONString(value);
            this.map.put(key, valueString);
            this.db.commit();
        }
        catch (Exception e) {
            this.db.rollback();
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(String key) throws FailStoreException {
        try {
            this.map.remove(key);
            this.db.commit();
        }
        catch (Exception e) {
            this.db.rollback();
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(List<String> keys) throws FailStoreException {
        if (keys == null || keys.size() == 0) {
            return;
        }
        try {
            for (String key : keys) {
                this.map.remove(key);
            }
            this.db.commit();
        }
        catch (Exception e) {
            this.db.rollback();
            throw new FailStoreException(e);
        }
    }

    @Override
    public <T> List<Pair<String, T>> fetchTop(int size, Type type) throws FailStoreException {
        ArrayList<Pair<String, T>> list = new ArrayList<Pair<String, T>>(size);
        if (this.map.size() == 0) {
            return list;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = JSON.parse((String)entry.getValue(), type);
            Pair pair = new Pair(key, value);
            list.add(pair);
            if (list.size() < size) continue;
            break;
        }
        return list;
    }

    @Override
    public void close() throws FailStoreException {
        try {
            this.db.close();
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void destroy() throws FailStoreException {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            FileUtils.delete(this.dbPath);
        }
    }
}

