/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.domain;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.exception.JobSubmitException;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.support.CronExpression;
import com.github.ltsopensource.remoting.annotation.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Job
implements Serializable {
    private static final long serialVersionUID = 7881199011994149340L;
    @NotNull
    private String taskId;
    private Integer priority = 100;
    private String submitNodeGroup;
    @NotNull
    private String taskTrackerNodeGroup;
    private Map<String, String> extParams;
    private boolean needFeedback = false;
    private int maxRetryTimes = 0;
    private String cronExpression;
    private int repeatCount = 0;
    private Long repeatInterval;
    private Long triggerTime;
    private boolean replaceOnExist = false;
    private boolean relyOnPrevCycle = true;

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getSubmitNodeGroup() {
        return this.submitNodeGroup;
    }

    public void setSubmitNodeGroup(String submitNodeGroup) {
        this.submitNodeGroup = submitNodeGroup;
    }

    public String getTaskTrackerNodeGroup() {
        return this.taskTrackerNodeGroup;
    }

    public void setTaskTrackerNodeGroup(String taskTrackerNodeGroup) {
        this.taskTrackerNodeGroup = taskTrackerNodeGroup;
    }

    public boolean isNeedFeedback() {
        return this.needFeedback;
    }

    public void setNeedFeedback(boolean needFeedback) {
        this.needFeedback = needFeedback;
    }

    public Map<String, String> getExtParams() {
        return this.extParams;
    }

    public void setExtParams(Map<String, String> extParams) {
        this.extParams = extParams;
    }

    public String getParam(String key) {
        if (this.extParams == null) {
            return null;
        }
        return this.extParams.get(key);
    }

    public void setParam(String key, String value) {
        if (this.extParams == null) {
            this.extParams = new HashMap<String, String>();
        }
        this.extParams.put(key, value);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public boolean isCron() {
        return this.cronExpression != null && !"".equals(this.cronExpression.trim());
    }

    public boolean isRepeatable() {
        return this.repeatInterval != null && this.repeatInterval > 0L && this.repeatCount >= -1 && this.repeatCount != 0;
    }

    public void setTriggerDate(Date date) {
        if (date != null) {
            this.triggerTime = date.getTime();
        }
    }

    public Long getTriggerTime() {
        return this.triggerTime;
    }

    public void setTriggerTime(Long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public boolean isReplaceOnExist() {
        return this.replaceOnExist;
    }

    public void setReplaceOnExist(boolean replaceOnExist) {
        this.replaceOnExist = replaceOnExist;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public boolean isRelyOnPrevCycle() {
        return this.relyOnPrevCycle;
    }

    public void setRelyOnPrevCycle(boolean relyOnPrevCycle) {
        this.relyOnPrevCycle = relyOnPrevCycle;
    }

    public String toString() {
        return JSON.toJSONString(this);
    }

    public void checkField() throws JobSubmitException {
        if (this.taskId == null) {
            throw new JobSubmitException("taskId can not be null! job is " + this.toString());
        }
        if (this.taskTrackerNodeGroup == null) {
            throw new JobSubmitException("taskTrackerNodeGroup can not be null! job is " + this.toString());
        }
        if (StringUtils.isNotEmpty(this.cronExpression) && !CronExpression.isValidExpression(this.cronExpression)) {
            throw new JobSubmitException("cronExpression invalid! job is " + this.toString());
        }
        if (this.maxRetryTimes < 0) {
            throw new JobSubmitException("maxRetryTimes invalid, must be great than zero! job is " + this.toString());
        }
        if (this.repeatCount < -1) {
            throw new JobSubmitException("repeatCount invalid, must be great than -1! job is " + this.toString());
        }
    }
}

