/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClassHelper {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[L";
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(16);
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveTypeMap = new HashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new HashMap(8);
    private static final Map<Class<?>, Object> primitiveTypeDftValueMap = new HashMap(8);

    public static Class<?> forNameWithThreadContextClassLoader(String name) throws ClassNotFoundException {
        return ClassHelper.forName(name, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> forNameWithCallerClassLoader(String name, Class<?> caller) throws ClassNotFoundException {
        return ClassHelper.forName(name, caller.getClassLoader());
    }

    public static ClassLoader getCallerClassLoader(Class<?> caller) {
        return caller.getClassLoader();
    }

    public static ClassLoader getClassLoader(Class<?> cls) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = cls.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader getClassLoader() {
        return ClassHelper.getClassLoader(ClassHelper.class);
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassHelper.forName(name, ClassHelper.getClassLoader());
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassHelper.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassHelper.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        int internalArrayMarker = name.indexOf(INTERNAL_ARRAY_PREFIX);
        if (internalArrayMarker != -1 && name.endsWith(";")) {
            String elementClassName = null;
            if (internalArrayMarker == 0) {
                elementClassName = name.substring(INTERNAL_ARRAY_PREFIX.length(), name.length() - 1);
            } else if (name.startsWith("[")) {
                elementClassName = name.substring(1);
            }
            Class<?> elementClass = ClassHelper.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassHelper.getClassLoader();
        }
        return classLoaderToUse.loadClass(name);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static Class<?> getPrimitiveTypeByWrapper(Class<?> clazz) {
        return wrapperPrimitiveTypeMap.get(clazz);
    }

    public static Class<?> getWrapperTypeByPrimitive(Class<?> clazz) {
        return primitiveWrapperTypeMap.get(clazz);
    }

    public static boolean isPrimitiveWrapperType(Class<?> clazz) {
        return wrapperPrimitiveTypeMap.containsKey(clazz);
    }

    public static Object getPrimitiveDftValue(Class<?> clazz) {
        return primitiveTypeDftValueMap.get(clazz);
    }

    public static String toShortString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getSimpleName() + "@" + System.identityHashCode(obj);
    }

    static {
        wrapperPrimitiveTypeMap.put(Boolean.class, Boolean.TYPE);
        wrapperPrimitiveTypeMap.put(Byte.class, Byte.TYPE);
        wrapperPrimitiveTypeMap.put(Character.class, Character.TYPE);
        wrapperPrimitiveTypeMap.put(Double.class, Double.TYPE);
        wrapperPrimitiveTypeMap.put(Float.class, Float.TYPE);
        wrapperPrimitiveTypeMap.put(Integer.class, Integer.TYPE);
        wrapperPrimitiveTypeMap.put(Long.class, Long.TYPE);
        wrapperPrimitiveTypeMap.put(Short.class, Short.TYPE);
        primitiveTypeDftValueMap.put(Boolean.TYPE, false);
        primitiveTypeDftValueMap.put(Byte.TYPE, 0);
        primitiveTypeDftValueMap.put(Character.TYPE, 0);
        primitiveTypeDftValueMap.put(Double.TYPE, 0);
        primitiveTypeDftValueMap.put(Float.TYPE, 0);
        primitiveTypeDftValueMap.put(Integer.TYPE, 0);
        primitiveTypeDftValueMap.put(Long.TYPE, 0);
        primitiveTypeDftValueMap.put(Short.TYPE, 0);
        for (Map.Entry<Class<?>, Class<?>> entry : wrapperPrimitiveTypeMap.entrySet()) {
            primitiveWrapperTypeMap.put(entry.getValue(), entry.getKey());
        }
        HashSet<Class> primitiveTypeNames = new HashSet<Class>(16);
        primitiveTypeNames.addAll(wrapperPrimitiveTypeMap.values());
        primitiveTypeNames.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        for (Class primitiveClass : primitiveTypeNames) {
            primitiveTypeNameMap.put(primitiveClass.getName(), primitiveClass);
        }
    }
}

