/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.AbstractJobNode;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.remoting.RemotingServerDelegate;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.RemotingServer;
import com.github.ltsopensource.remoting.RemotingServerConfig;
import com.github.ltsopensource.remoting.RemotingTransporter;
import java.util.concurrent.Executors;

public abstract class AbstractServerNode<T extends Node, App extends AppContext>
extends AbstractJobNode<T, App> {
    protected RemotingServerDelegate remotingServer;

    @Override
    protected void remotingStart() {
        this.remotingServer.start();
        RemotingProcessor defaultProcessor = this.getDefaultProcessor();
        if (defaultProcessor != null) {
            int processorSize = this.config.getParameter("job.processor.thread", Constants.DEFAULT_PROCESSOR_THREAD);
            this.remotingServer.registerDefaultProcessor(defaultProcessor, Executors.newFixedThreadPool(processorSize, new NamedThreadFactory(AbstractServerNode.class.getSimpleName(), true)));
        }
    }

    public void setListenPort(int listenPort) {
        this.config.setListenPort(listenPort);
    }

    @Override
    protected void remotingStop() {
        this.remotingServer.shutdown();
    }

    @Override
    protected void beforeRemotingStart() {
        RemotingServerConfig remotingServerConfig = new RemotingServerConfig();
        if (this.config.getListenPort() == 0) {
            this.config.setListenPort(35001);
            this.node.setPort(this.config.getListenPort());
        }
        remotingServerConfig.setListenPort(this.config.getListenPort());
        this.remotingServer = new RemotingServerDelegate(this.getRemotingServer(remotingServerConfig), this.appContext);
        this.beforeStart();
    }

    private RemotingServer getRemotingServer(RemotingServerConfig remotingServerConfig) {
        return ServiceLoader.load(RemotingTransporter.class, this.config).getRemotingServer(this.appContext, remotingServerConfig);
    }

    @Override
    protected void afterRemotingStart() {
        this.afterStart();
    }

    @Override
    protected void beforeRemotingStop() {
        this.beforeStop();
    }

    @Override
    protected void afterRemotingStop() {
        this.afterStop();
    }

    protected abstract RemotingProcessor getDefaultProcessor();

    protected abstract void beforeStart();

    protected abstract void afterStart();

    protected abstract void afterStop();

    protected abstract void beforeStop();
}

