/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.cmd;

import com.github.ltsopensource.cmd.HttpCmdAcceptor;
import com.github.ltsopensource.cmd.HttpCmdContext;
import com.github.ltsopensource.cmd.HttpCmdException;
import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpCmdServer {
    private final Logger LOGGER = LoggerFactory.getLogger(HttpCmdServer.class);
    private final AtomicBoolean start = new AtomicBoolean(false);
    private HttpCmdAcceptor acceptor;
    private int port;
    private String bindAddr;
    private HttpCmdContext context;
    private int portFindTimes;

    private HttpCmdServer(String bindAddr, int port) {
        this.port = port > 0 ? port : 8719;
        this.bindAddr = bindAddr;
        this.context = new HttpCmdContext();
    }

    public void start() throws HttpCmdException {
        try {
            if (this.start.compareAndSet(false, true)) {
                this.acceptor = new HttpCmdAcceptor(this.getServerSocket(), this.context);
                this.acceptor.start();
                this.LOGGER.info("Start succeed at port {}", this.port);
            }
        }
        catch (Exception t) {
            this.LOGGER.error("Start error at port {}", this.port, t);
            throw new HttpCmdException(t);
        }
    }

    private ServerSocket getServerSocket() throws IOException {
        ServerSocket serverSocket;
        block2: {
            serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port, 100);
                serverSocket.setReuseAddress(true);
            }
            catch (BindException e) {
                ++this.port;
                serverSocket = this.getServerSocket();
                if (this.portFindTimes++ <= 50) break block2;
                throw e;
            }
        }
        return serverSocket;
    }

    public void stop() {
        if (this.acceptor != null) {
            this.acceptor.stop();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void registerCommand(HttpCmdProc proc) {
        this.context.addCmdProcessor(proc);
    }

    public void registerCommands(HttpCmdProc ... procs) {
        if (procs != null && procs.length > 0) {
            for (HttpCmdProc proc : procs) {
                this.registerCommand(proc);
            }
        }
    }

    public static class Factory {
        private static HttpCmdServer httpCmdServer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HttpCmdServer getHttpCmdServer(String bindAddr, int port) {
            if (httpCmdServer != null) {
                return httpCmdServer;
            }
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (httpCmdServer != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return httpCmdServer;
                }
                httpCmdServer = new HttpCmdServer(bindAddr, port);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return httpCmdServer;
            }
        }
    }
}

