/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.cmd;

import com.github.ltsopensource.cmd.HttpCmdContext;
import com.github.ltsopensource.cmd.HttpCmdExecutor;
import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpCmdAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCmdAcceptor.class);
    private final AtomicBoolean start = new AtomicBoolean(false);
    private final ExecutorService executorService;
    private ServerSocket serverSocket;
    private Thread thread;
    private HttpCmdContext context;

    public HttpCmdAcceptor(ServerSocket serverSocket, HttpCmdContext context) {
        this.context = context;
        this.serverSocket = serverSocket;
        this.executorService = new ThreadPoolExecutor(Constants.AVAILABLE_PROCESSOR, Constants.AVAILABLE_PROCESSOR, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadPoolExecutor.DiscardPolicy());
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        if (this.thread == null) {
            this.thread = new NamedThreadFactory("HTTP-CMD-ACCEPTOR", true).newThread(new Runnable(){

                @Override
                public void run() {
                    while (HttpCmdAcceptor.this.isStarted()) {
                        try {
                            Socket socket = HttpCmdAcceptor.this.serverSocket.accept();
                            if (socket == null) continue;
                            HttpCmdAcceptor.this.executorService.submit(new HttpCmdExecutor(HttpCmdAcceptor.this.context, socket));
                        }
                        catch (Throwable t) {
                            LOGGER.error("Accept error ", t);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            });
        }
        this.thread.start();
        LOGGER.info("HttpCmdAcceptor start succeed ");
    }

    public void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                this.executorService.shutdown();
                LOGGER.info("HttpCmdAcceptor stop succeed ");
            }
        }
        catch (Throwable t) {
            LOGGER.error("HttpCmdAcceptor stop error ", t);
        }
    }

    private boolean isStarted() {
        return this.start.get();
    }
}

