/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification.transmission;

import java.util.List;
import java.util.Vector;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.Devices;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.notification.AppleNotificationServer;
import javapns.notification.Payload;
import javapns.notification.PayloadPerDevice;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import javapns.notification.transmission.NotificationProgressListener;
import javapns.notification.transmission.NotificationThreads;
import javapns.notification.transmission.PushQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationThread
implements Runnable,
PushQueue {
    private static final int DEFAULT_MAXNOTIFICATIONSPERCONNECTION = 200;
    private Thread thread;
    private boolean started = false;
    private PushNotificationManager notificationManager;
    private AppleNotificationServer server;
    private int maxNotificationsPerConnection = 200;
    private long sleepBetweenNotifications = 0L;
    private NotificationProgressListener listener;
    private int threadNumber = 1;
    private int nextMessageIdentifier = 1;
    private PushedNotifications notifications = new PushedNotifications();
    private MODE mode = MODE.LIST;
    private boolean busy = false;
    private Payload payload;
    private List<Device> devices;
    private List<PayloadPerDevice> messages = new Vector<PayloadPerDevice>();
    private Exception exception;

    public NotificationThread(NotificationThreads threads, PushNotificationManager notificationManager, AppleNotificationServer server, Payload payload, Object devices) {
        this.thread = new Thread(threads, this, "JavaPNS" + (threads != null ? " grouped" : " standalone") + " notification thread in LIST mode");
        this.notificationManager = notificationManager == null ? new PushNotificationManager() : notificationManager;
        this.server = server;
        this.payload = payload;
        this.devices = Devices.asDevices(devices);
        this.notifications.setMaxRetained(this.devices.size());
    }

    public NotificationThread(NotificationThreads threads, PushNotificationManager notificationManager, AppleNotificationServer server, Object messages) {
        this.thread = new Thread(threads, this, "JavaPNS" + (threads != null ? " grouped" : " standalone") + " notification thread in LIST mode");
        this.notificationManager = notificationManager == null ? new PushNotificationManager() : notificationManager;
        this.server = server;
        this.messages = Devices.asPayloadsPerDevices(messages);
        this.notifications.setMaxRetained(this.messages.size());
    }

    public NotificationThread(PushNotificationManager notificationManager, AppleNotificationServer server, Payload payload, Object devices) {
        this(null, notificationManager, server, payload, devices);
    }

    public NotificationThread(PushNotificationManager notificationManager, AppleNotificationServer server, Object messages) {
        this(null, notificationManager, server, messages);
    }

    public NotificationThread(NotificationThreads threads, PushNotificationManager notificationManager, AppleNotificationServer server) {
        this.thread = new Thread(threads, this, "JavaPNS" + (threads != null ? " grouped" : " standalone") + " notification thread in QUEUE mode");
        this.notificationManager = notificationManager == null ? new PushNotificationManager() : notificationManager;
        this.server = server;
        this.mode = MODE.QUEUE;
        this.thread.setDaemon(true);
    }

    public NotificationThread(PushNotificationManager notificationManager, AppleNotificationServer server) {
        this(null, notificationManager, server);
    }

    public NotificationThread(AppleNotificationServer server) {
        this(null, new PushNotificationManager(), server);
    }

    @Override
    public synchronized NotificationThread start() {
        if (this.started) {
            return this;
        }
        this.started = true;
        try {
            this.thread.start();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void run() {
        switch (this.mode) {
            case LIST: {
                this.runList();
                break;
            }
            case QUEUE: {
                this.runQueue();
                break;
            }
        }
    }

    private void runList() {
        block14: {
            if (this.listener != null) {
                this.listener.eventThreadStarted(this);
            }
            this.busy = true;
            try {
                int total = this.size();
                this.notificationManager.initializeConnection(this.server);
                for (int i = 0; i < total; ++i) {
                    Payload payload;
                    Device device;
                    if (this.devices != null) {
                        device = this.devices.get(i);
                        payload = this.payload;
                    } else {
                        PayloadPerDevice message = this.messages.get(i);
                        device = message.getDevice();
                        payload = message.getPayload();
                    }
                    int message = this.newMessageIdentifier();
                    PushedNotification notification = this.notificationManager.sendNotification(device, payload, false, message);
                    this.notifications.add(notification);
                    try {
                        if (this.sleepBetweenNotifications > 0L) {
                            Thread.sleep(this.sleepBetweenNotifications);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (i == 0 || i % this.maxNotificationsPerConnection != 0) continue;
                    if (this.listener != null) {
                        this.listener.eventConnectionRestarted(this);
                    }
                    this.notificationManager.restartConnection(this.server);
                }
                this.notificationManager.stopConnection();
            }
            catch (KeystoreException e) {
                this.exception = e;
                if (this.listener != null) {
                    this.listener.eventCriticalException(this, e);
                }
            }
            catch (CommunicationException e) {
                this.exception = e;
                if (this.listener == null) break block14;
                this.listener.eventCriticalException(this, e);
            }
        }
        this.busy = false;
        if (this.listener != null) {
            this.listener.eventThreadFinished(this);
        }
        if (this.thread.getThreadGroup() instanceof NotificationThreads) {
            ((NotificationThreads)this.thread.getThreadGroup()).threadFinished(this);
        }
    }

    private void runQueue() {
        block16: {
            if (this.listener != null) {
                this.listener.eventThreadStarted(this);
            }
            try {
                this.notificationManager.initializeConnection(this.server);
                int notificationsPushed = 0;
                while (this.mode == MODE.QUEUE) {
                    while (!this.messages.isEmpty()) {
                        this.busy = true;
                        PayloadPerDevice message = this.messages.get(0);
                        this.messages.remove(message);
                        ++notificationsPushed;
                        int messageId = this.newMessageIdentifier();
                        PushedNotification notification = this.notificationManager.sendNotification(message.getDevice(), message.getPayload(), false, messageId);
                        this.notifications.add(notification);
                        try {
                            if (this.sleepBetweenNotifications > 0L) {
                                Thread.sleep(this.sleepBetweenNotifications);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (notificationsPushed != 0 && notificationsPushed % this.maxNotificationsPerConnection == 0) {
                            if (this.listener != null) {
                                this.listener.eventConnectionRestarted(this);
                            }
                            this.notificationManager.restartConnection(this.server);
                        }
                        this.busy = false;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {}
                }
                this.notificationManager.stopConnection();
            }
            catch (KeystoreException e) {
                this.exception = e;
                if (this.listener != null) {
                    this.listener.eventCriticalException(this, e);
                }
            }
            catch (CommunicationException e) {
                this.exception = e;
                if (this.listener == null) break block16;
                this.listener.eventCriticalException(this, e);
            }
        }
        if (this.listener != null) {
            this.listener.eventThreadFinished(this);
        }
        if (this.thread.getThreadGroup() instanceof NotificationThreads) {
            ((NotificationThreads)this.thread.getThreadGroup()).threadFinished(this);
        }
    }

    @Override
    public PushQueue add(Payload payload, String token) throws InvalidDeviceTokenFormatException {
        return this.add(new PayloadPerDevice(payload, token));
    }

    @Override
    public PushQueue add(Payload payload, Device device) {
        return this.add(new PayloadPerDevice(payload, device));
    }

    @Override
    public PushQueue add(PayloadPerDevice message) {
        if (this.mode != MODE.QUEUE) {
            return this;
        }
        try {
            this.messages.add(message);
            this.thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public void setMaxNotificationsPerConnection(int maxNotificationsPerConnection) {
        this.maxNotificationsPerConnection = maxNotificationsPerConnection;
    }

    public int getMaxNotificationsPerConnection() {
        return this.maxNotificationsPerConnection;
    }

    public void setSleepBetweenNotifications(long milliseconds) {
        this.sleepBetweenNotifications = milliseconds;
    }

    public long getSleepBetweenNotifications() {
        return this.sleepBetweenNotifications;
    }

    void setDevices(List<Device> devices) {
        this.devices = devices;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public int size() {
        return this.devices != null ? this.devices.size() : this.messages.size();
    }

    public void setListener(NotificationProgressListener listener) {
        this.listener = listener;
    }

    public NotificationProgressListener getListener() {
        return this.listener;
    }

    protected void setThreadNumber(int threadNumber) {
        this.threadNumber = threadNumber;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public int newMessageIdentifier() {
        return this.threadNumber << 24 | this.nextMessageIdentifier++;
    }

    public int getFirstMessageIdentifier() {
        return this.threadNumber << 24 | 1;
    }

    public int getLastMessageIdentifier() {
        return this.threadNumber << 24 | this.size();
    }

    @Override
    public PushedNotifications getPushedNotifications() {
        return this.notifications;
    }

    @Override
    public void clearPushedNotifications() {
        this.notifications.clear();
    }

    public PushedNotifications getFailedNotifications() {
        return this.getPushedNotifications().getFailedNotifications();
    }

    public PushedNotifications getSuccessfulNotifications() {
        return this.getPushedNotifications().getSuccessfulNotifications();
    }

    void setMessages(List<PayloadPerDevice> messages) {
        this.messages = messages;
    }

    public List<PayloadPerDevice> getMessages() {
        return this.messages;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public Exception getCriticalException() {
        return this.exception;
    }

    @Override
    public List<Exception> getCriticalExceptions() {
        Vector<Exception> exceptions = new Vector<Exception>(this.exception == null ? 0 : 1);
        if (this.exception != null) {
            exceptions.add(this.exception);
        }
        return exceptions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MODE {
        LIST,
        QUEUE;

    }
}

