/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.token;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;

public class WeixinTokenCreator
extends TokenCreator {
    private final String appid;
    private final String secret;

    public WeixinTokenCreator(String appid, String secret) {
        this.appid = appid;
        this.secret = secret;
    }

    public String key0() {
        return String.format("mp_token_%s", this.appid);
    }

    public Token create() throws WeixinException {
        String tokenUrl = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.appid, this.secret);
        WeixinResponse response = this.weixinExecutor.get(tokenUrl, new URLParameter[0]);
        JSONObject result = response.getAsJson();
        return new Token(result.getString("access_token"), result.getLongValue("expires_in") * 1000L);
    }
}

