/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.token;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.type.TicketType;

public class WeixinTicketCreator
extends TokenCreator {
    private final String appid;
    private final TicketType ticketType;
    private final TokenManager weixinTokenManager;

    public WeixinTicketCreator(String appid, TicketType ticketType, TokenManager weixinTokenManager) {
        this.appid = appid;
        this.ticketType = ticketType;
        this.weixinTokenManager = weixinTokenManager;
    }

    public String key0() {
        return String.format("mp_ticket_%s_%s", this.ticketType.name(), this.appid);
    }

    public Token create() throws WeixinException {
        WeixinResponse response = this.weixinExecutor.get(String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=%s", this.weixinTokenManager.getAccessToken(), this.ticketType.name()), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        return new Token(result.getString("ticket"), result.getLongValue("expires_in") * 1000L);
    }
}

