/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.oldpayment;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.mp.oldpayment.ApiResultV2;
import com.foxinmy.weixin4j.type.mch.RefundChannel;
import com.foxinmy.weixin4j.type.mch.RefundStatus;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RefundDetailV2
extends ApiResultV2 {
    private static final long serialVersionUID = -3687863914168618620L;
    @XmlElement(name="out_refund_no")
    @JSONField(name="out_refund_no")
    private String outRefundNo;
    @XmlElement(name="refund_id")
    @JSONField(name="refund_id")
    private String refundId;
    @XmlElement(name="refund_channel")
    @JSONField(name="refund_channel")
    private int refundChannel;
    @XmlElement(name="refund_fee")
    @JSONField(name="refund_fee")
    private int refundFee;
    @XmlElement(name="refund_status")
    @JSONField(name="refund_status")
    private int refundStatus;
    @XmlElement(name="recv_user_id")
    @JSONField(name="recv_user_id")
    private String recvUserId;
    @XmlElement(name="reccv_user_name")
    @JSONField(name="reccv_user_name")
    private String reccvUserName;

    protected RefundDetailV2() {
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public int getRefundChannel() {
        return this.refundChannel;
    }

    @JSONField(serialize=false)
    public RefundChannel getFormatRefundChannel() {
        if (this.refundChannel == 0) {
            return RefundChannel.TENPAY;
        }
        if (this.refundChannel == 1) {
            return RefundChannel.BANK;
        }
        return null;
    }

    public int getRefundFee() {
        return this.refundFee;
    }

    @JSONField(serialize=false)
    public double getFormatRefundFee() {
        return (double)this.refundFee / 100.0;
    }

    public int getRefundStatus() {
        return this.refundStatus;
    }

    @JSONField(serialize=false)
    public RefundStatus getFormatRefundStatus() {
        String refundStatus_ = String.format(",%d,", this.refundStatus);
        if (",4,10,".contains(refundStatus_)) {
            return RefundStatus.SUCCESS;
        }
        if (",3,5,6,".contains(refundStatus_)) {
            return RefundStatus.FAIL;
        }
        if (",8,9,11,".contains(refundStatus_)) {
            return RefundStatus.PROCESSING;
        }
        if (",1,2,".contains(refundStatus_)) {
            return RefundStatus.NOTSURE;
        }
        if (",7,".contains(refundStatus_)) {
            return RefundStatus.CHANGE;
        }
        return null;
    }

    public String getRecvUserId() {
        return this.recvUserId;
    }

    public String getReccvUserName() {
        return this.reccvUserName;
    }

    @Override
    public String toString() {
        return "outRefundNo=" + this.outRefundNo + ", refundId=" + this.refundId + ", refundChannel=" + this.refundChannel + ", refundFee=" + this.refundFee + ", refundStatus=" + this.refundStatus + ", recvUserId=" + this.recvUserId + ", reccvUserName=" + this.reccvUserName + ", refundChannel=" + this.getFormatRefundChannel() + ", refundFee=" + this.getFormatRefundFee() + ", refundStatus=" + this.getFormatRefundStatus();
    }
}

