/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.oldpayment;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.mp.oldpayment.PayPackageV2;
import com.foxinmy.weixin4j.mp.oldpayment.WeixinOldPayAccount;
import com.foxinmy.weixin4j.mp.oldpayment.WeixinOldPaymentSignature;
import com.foxinmy.weixin4j.payment.PayRequest;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NativePayResponseV2
extends PayRequest {
    private static final long serialVersionUID = 6119895998783333012L;
    @JSONField(name="RetCode")
    @XmlElement(name="RetCode")
    private String retCode;
    @JSONField(name="RetErrMsg")
    @XmlElement(name="RetErrMsg")
    private String retMsg;

    protected NativePayResponseV2() {
    }

    public NativePayResponseV2(String errorMsg) {
        this.retCode = "-1";
        this.retMsg = errorMsg;
    }

    public NativePayResponseV2(WeixinOldPayAccount weixinAccount, PayPackageV2 payPackage) {
        super(weixinAccount.getId(), null);
        this.retCode = "0";
        this.retMsg = "OK";
        WeixinOldPaymentSignature weixinSignature = new WeixinOldPaymentSignature(weixinAccount.getPaySignKey(), weixinAccount.getPartnerKey());
        this.setPackageInfo(weixinSignature.sign(payPackage));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", weixinAccount.getId());
        map.put("appkey", weixinAccount.getPaySignKey());
        map.put("timestamp", this.getTimeStamp());
        map.put("noncestr", this.getNonceStr());
        map.put("package", this.getPackageInfo());
        map.put("retcode", this.getRetCode());
        map.put("reterrmsg", this.getRetMsg());
        this.setPaySign(weixinSignature.sign(map));
    }

    public String getRetCode() {
        return this.retCode;
    }

    public String getRetMsg() {
        return this.retMsg;
    }

    public String toString() {
        return "NativePayResponseV2 [retCode=" + this.retCode + ", retMsg=" + this.retMsg + ", " + super.toString() + "]";
    }
}

