/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.mp.type.FaceSize;
import com.foxinmy.weixin4j.mp.type.Lang;
import com.foxinmy.weixin4j.type.Gender;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class User
implements Serializable {
    private static final long serialVersionUID = 1638176217299286265L;
    @JSONField(name="openid")
    private String openId;
    @JSONField(name="nickname")
    private String nickName;
    @JSONField(name="sex")
    private int gender;
    private String province;
    private String city;
    private String country;
    private String headimgurl;
    private JSONArray privilege;
    @JSONField(name="subscribe")
    private boolean isSubscribe;
    @JSONField(name="subscribe_time")
    private long subscribeTime;
    private String language;
    @JSONField(name="unionid")
    private String unionId;
    private String remark;
    @JSONField(name="groupid")
    private int groupId;
    @JSONField(name="tagid_list")
    private List<Integer> tagIds;

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public int getGender() {
        return this.gender;
    }

    @JSONField(serialize=false)
    public Gender getFormatGender() {
        if (this.gender == 1) {
            return Gender.male;
        }
        if (this.gender == 2) {
            return Gender.female;
        }
        return Gender.unknown;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getHeadimgurl() {
        return this.headimgurl;
    }

    public String getHeadimgurl(FaceSize size) {
        if (StringUtil.isNotBlank((CharSequence)this.headimgurl)) {
            StringBuilder sb = new StringBuilder(this.headimgurl);
            return sb.replace(0, this.headimgurl.length() - 1, size.getInt() + "").toString();
        }
        return "";
    }

    public void setHeadimgurl(String headimgurl) {
        this.headimgurl = headimgurl;
    }

    public JSONArray getPrivilege() {
        return this.privilege;
    }

    public void setPrivilege(JSONArray privilege) {
        this.privilege = privilege;
    }

    public String getLanguage() {
        return this.language;
    }

    @JSONField(serialize=false)
    public Lang getFormatLanguage() {
        return this.language != null ? Lang.valueOf(this.language) : null;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isSubscribe() {
        return this.isSubscribe;
    }

    public void setSubscribe(boolean isSubscribe) {
        this.isSubscribe = isSubscribe;
    }

    public long getSubscribeTime() {
        return this.subscribeTime;
    }

    @JSONField(serialize=false)
    public Date getFormatSubscribeTime() {
        return new Date(this.subscribeTime * 1000L);
    }

    public void setSubscribeTime(long subscribeTime) {
        this.subscribeTime = subscribeTime;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public List<Integer> getTagIds() {
        return this.tagIds;
    }

    public void setTagIds(List<Integer> tagIds) {
        this.tagIds = tagIds;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User another = (User)obj;
            if (this.unionId != null && another.getUnionId() != null) {
                return this.unionId.equals(another.getUnionId());
            }
            if (this.openId != null && another.getOpenId() != null) {
                return this.openId.equals(another.getOpenId());
            }
        }
        return false;
    }

    public String toString() {
        return "User [openId=" + this.openId + ", nickName=" + this.nickName + ", gender=" + this.gender + ", province=" + this.province + ", city=" + this.city + ", country=" + this.country + ", headimgurl=" + this.headimgurl + ", privilege=" + this.privilege + ", isSubscribe=" + this.isSubscribe + ", subscribeTime=" + this.subscribeTime + ", language=" + this.language + ", unionId=" + this.unionId + ", remark=" + this.remark + ", groupId=" + this.groupId + ", tagIds=" + this.tagIds + "]";
    }
}

