/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.component;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;

public class WeixinComponentTokenCreator
extends TokenCreator {
    private final TicketManager ticketManager;

    public WeixinComponentTokenCreator(TicketManager ticketManager) {
        this.ticketManager = ticketManager;
    }

    public String key0() {
        return String.format("mp_component_token_%s", this.ticketManager.getThirdId());
    }

    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("component_appid", (Object)this.ticketManager.getThirdId());
        obj.put("component_appsecret", (Object)this.ticketManager.getThirdSecret());
        obj.put("component_verify_ticket", (Object)this.ticketManager.getAccessTicket());
        WeixinResponse response = this.weixinExecutor.post("https://api.weixin.qq.com/cgi-bin/component/api_component_token", obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("component_access_token"), obj.getLongValue("expires_in") * 1000L);
    }
}

