/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.component;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;

public class WeixinComponentPreCodeCreator
extends TokenCreator {
    private final TokenManager componentTokenManager;
    private final String componentId;

    public WeixinComponentPreCodeCreator(TokenManager componentTokenManager, String componentId) {
        this.componentTokenManager = componentTokenManager;
        this.componentId = componentId;
    }

    public String key0() {
        return String.format("mp_component_precode_%s", this.componentId);
    }

    public Token create() throws WeixinException {
        WeixinResponse response = this.weixinExecutor.post(String.format("https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode?component_access_token=%s", this.componentTokenManager.getAccessToken()), String.format("{\"component_appid\":\"%s\"}", this.componentId));
        JSONObject result = response.getAsJson();
        return new Token(result.getString("pre_auth_code"), result.getLongValue("expires_in") * 1000L);
    }
}

