/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.message.TemplateMessage;
import com.foxinmy.weixin4j.mp.model.TemplateMessageInfo;
import com.foxinmy.weixin4j.mp.type.IndustryType;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.NameValue;
import java.util.List;

public class TmplApi
extends MpApi {
    private final TokenManager tokenManager;

    public TmplApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public ApiResult setTmplIndustry(IndustryType ... industryTypes) throws WeixinException {
        JSONObject obj = new JSONObject();
        for (int i = 0; i < industryTypes.length; ++i) {
            obj.put(String.format("industry_id%d", i + 1), (Object)Integer.toString(industryTypes[i].getTypeId()));
        }
        Token token = (Token)this.tokenManager.getCache();
        String template_set_industry_uri = this.getRequestUri("template_set_industry_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(template_set_industry_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public IndustryType[] getTmplIndustry() throws WeixinException {
        String template_get_industry_uri = this.getRequestUri("template_get_industry_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(template_get_industry_uri, this.tokenManager.getAccessToken()), new URLParameter[0]);
        JSONObject primary = response.getAsJson().getJSONObject("primary_industry");
        JSONObject secondary = response.getAsJson().getJSONObject("secondary_industry");
        return new IndustryType[]{primary != null ? IndustryType.getIndustry(primary.getString("first_class"), primary.getString("second_class")) : null, secondary != null ? IndustryType.getIndustry(secondary.getString("first_class"), secondary.getString("second_class")) : null};
    }

    public String getTemplateId(String shortId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String template_getid_uri = this.getRequestUri("template_getid_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(template_getid_uri, token.getAccessToken()), String.format("{\"template_id_short\":\"%s\"}", shortId));
        return response.getAsJson().getString("template_id");
    }

    public List<TemplateMessageInfo> getAllTemplates() throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String template_getall_uri = this.getRequestUri("template_getall_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(template_getall_uri, token.getAccessToken()), new URLParameter[0]);
        return JSON.parseArray((String)response.getAsJson().getString("template_list"), TemplateMessageInfo.class);
    }

    public ApiResult deleteTemplate(String templateId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String template_del_uri = this.getRequestUri("template_del_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(template_del_uri, token.getAccessToken()), String.format("{\"template_id\":\"%s\"}", templateId));
        return response.getAsResult();
    }

    public String sendTmplMessage(TemplateMessage tplMessage) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String template_send_uri = this.getRequestUri("template_send_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(template_send_uri, token.getAccessToken()), JSON.toJSONString((Object)tplMessage, (SerializeFilter)new NameFilter(){

            public String process(Object object, String name, Object value) {
                if (object instanceof NameValue && name.equals("name")) {
                    return "color";
                }
                return name;
            }
        }, (SerializerFeature[])new SerializerFeature[0]));
        return response.getAsJson().getString("msgid");
    }
}

