/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.apache.ByteArrayBody;
import com.foxinmy.weixin4j.http.apache.ContentBody;
import com.foxinmy.weixin4j.http.apache.FormBodyPart;
import com.foxinmy.weixin4j.http.apache.InputStreamBody;
import com.foxinmy.weixin4j.http.apache.StringBody;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import com.foxinmy.weixin4j.http.entity.StringEntity;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.media.MediaCounter;
import com.foxinmy.weixin4j.model.media.MediaDownloadResult;
import com.foxinmy.weixin4j.model.media.MediaItem;
import com.foxinmy.weixin4j.model.media.MediaRecord;
import com.foxinmy.weixin4j.model.media.MediaUploadResult;
import com.foxinmy.weixin4j.model.paging.Pageable;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MpArticle;
import com.foxinmy.weixin4j.tuple.MpVideo;
import com.foxinmy.weixin4j.type.MediaType;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.FileUtil;
import com.foxinmy.weixin4j.util.IOUtil;
import com.foxinmy.weixin4j.util.ObjectId;
import com.foxinmy.weixin4j.util.RegexUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MediaApi
extends MpApi {
    private final TokenManager tokenManager;

    public MediaApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String uploadImage(InputStream is, String fileName) throws WeixinException {
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = ObjectId.get().toHexString();
        }
        if (StringUtil.isBlank((CharSequence)FileUtil.getFileExtension((String)fileName))) {
            fileName = String.format("%s.jpg", fileName);
        }
        String image_upload_uri = this.getRequestUri("image_upload_uri");
        MimeType mimeType = new MimeType("image", FileUtil.getFileExtension((String)fileName));
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(image_upload_uri, token.getAccessToken()), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new InputStreamBody(is, mimeType.toString(), fileName))});
        return response.getAsJson().getString("url");
    }

    public MpVideo uploadVideo(InputStream is, String fileName, String title, String description) throws WeixinException {
        MediaUploadResult uploadResult = this.uploadMedia(false, is, fileName);
        JSONObject obj = new JSONObject();
        obj.put("media_id", (Object)uploadResult.getMediaId());
        obj.put("title", (Object)title);
        obj.put("description", (Object)description);
        String video_upload_uri = this.getRequestUri("video_upload_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(video_upload_uri, token.getAccessToken()), obj.toJSONString());
        String mediaId = response.getAsJson().getString("media_id");
        return new MpVideo(mediaId);
    }

    public MediaUploadResult uploadMedia(boolean isMaterial, InputStream is, String fileName) throws WeixinException {
        MediaUploadResult mediaUploadResult;
        MediaType mediaType;
        String suffixName;
        byte[] content;
        try {
            content = IOUtil.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new WeixinException((Throwable)e);
        }
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = ObjectId.get().toHexString();
        }
        if (StringUtil.isBlank((CharSequence)(suffixName = FileUtil.getFileExtension((String)fileName)))) {
            suffixName = FileUtil.getFileType((InputStream)new ByteArrayInputStream(content));
            fileName = String.format("%s.%s", fileName, suffixName);
        }
        if (",bmp,png,jpeg,jpg,gif,".contains(String.format(",%s,", suffixName))) {
            mediaType = MediaType.image;
        } else if (",mp3,wma,wav,amr,".contains(String.format(",%s,", suffixName))) {
            mediaType = MediaType.voice;
        } else if (",rm,rmvb,wmv,avi,mpg,mpeg,mp4,".contains(String.format(",%s,", suffixName))) {
            mediaType = MediaType.video;
        } else {
            throw new WeixinException("cannot handle mediaType:" + suffixName);
        }
        if (mediaType == MediaType.video && isMaterial) {
            throw new WeixinException("please invoke uploadMaterialVideo method");
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = null;
        try {
            if (isMaterial) {
                String material_media_upload_uri = this.getRequestUri("material_media_upload_uri");
                response = this.weixinExecutor.post(String.format(material_media_upload_uri, token.getAccessToken()), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new ByteArrayBody(content, mediaType.getMimeType().toString(), fileName)), new FormBodyPart("type", (ContentBody)new StringBody(mediaType.name(), Consts.UTF_8))});
                JSONObject obj = response.getAsJson();
                MediaUploadResult mediaUploadResult2 = new MediaUploadResult(obj.getString("media_id"), mediaType, new Date(), obj.getString("url"));
                return mediaUploadResult2;
            }
            String media_upload_uri = this.getRequestUri("media_upload_uri");
            response = this.weixinExecutor.post(String.format(media_upload_uri, token.getAccessToken(), mediaType.name()), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream(content), mediaType.getMimeType().toString(), fileName))});
            JSONObject obj = response.getAsJson();
            mediaUploadResult = new MediaUploadResult(obj.getString("media_id"), (MediaType)obj.getObject("type", MediaType.class), new Date(obj.getLong("created_at") * 1000L), obj.getString("url"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeixinException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return mediaUploadResult;
    }

    public MediaDownloadResult downloadMedia(String mediaId, boolean isMaterial) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        HttpRequest request = null;
        if (isMaterial) {
            String material_media_download_uri = this.getRequestUri("material_media_download_uri");
            request = new HttpRequest(HttpMethod.POST, String.format(material_media_download_uri, token.getAccessToken()));
            request.setEntity((HttpEntity)new StringEntity(String.format("{\"media_id\":\"%s\"}", mediaId)));
        } else {
            String meida_download_uri = this.getRequestUri("meida_download_uri");
            request = new HttpRequest(HttpMethod.GET, String.format(meida_download_uri, token.getAccessToken(), mediaId));
        }
        WeixinResponse response = this.weixinExecutor.doRequest(request);
        HttpHeaders headers = response.getHeaders();
        String contentType = headers.getFirst("Content-Type");
        String disposition = headers.getFirst("Content-Disposition");
        String fileName = RegexUtil.regexFileNameFromContentDispositionHeader((String)disposition);
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = String.format("%s.%s", mediaId, contentType.split("/")[1]);
        }
        return new MediaDownloadResult(response.getContent(), ContentType.create((String)contentType), fileName);
    }

    public String uploadMaterialArticle(List<MpArticle> articles) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_article_upload_uri = this.getRequestUri("material_article_upload_uri");
        JSONObject obj = new JSONObject();
        obj.put("articles", articles);
        WeixinResponse response = this.weixinExecutor.post(String.format(material_article_upload_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("media_id");
    }

    public List<MpArticle> downloadArticle(String mediaId) throws WeixinException {
        MediaDownloadResult result = this.downloadMedia(mediaId, true);
        byte[] content = result.getContent();
        JSONObject obj = (JSONObject)JSON.parseObject((byte[])content, (int)0, (int)content.length, (CharsetDecoder)Consts.UTF_8.newDecoder(), JSONObject.class, (Feature[])new Feature[0]);
        return JSON.parseArray((String)obj.getString("news_item"), MpArticle.class);
    }

    public ApiResult updateMaterialArticle(String mediaId, int index, MpArticle article) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_article_update_uri = this.getRequestUri("material_article_update_uri");
        JSONObject obj = new JSONObject();
        obj.put("articles", (Object)article);
        obj.put("media_id", (Object)mediaId);
        obj.put("index", (Object)index);
        WeixinResponse response = this.weixinExecutor.post(String.format(material_article_update_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult deleteMaterialMedia(String mediaId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_media_del_uri = this.getRequestUri("material_media_del_uri");
        JSONObject obj = new JSONObject();
        obj.put("media_id", (Object)mediaId);
        WeixinResponse response = this.weixinExecutor.post(String.format(material_media_del_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public String uploadMaterialVideo(InputStream is, String fileName, String title, String introduction) throws WeixinException {
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = ObjectId.get().toHexString();
        }
        if (StringUtil.isBlank((CharSequence)FileUtil.getFileExtension((String)fileName))) {
            fileName = String.format("%s.mp4", fileName);
        }
        String material_media_upload_uri = this.getRequestUri("material_media_upload_uri");
        MimeType mimeType = new MimeType("video", FileUtil.getFileExtension((String)fileName));
        Token token = (Token)this.tokenManager.getCache();
        try {
            JSONObject description = new JSONObject();
            description.put("title", (Object)title);
            description.put("introduction", (Object)introduction);
            WeixinResponse response = this.weixinExecutor.post(String.format(material_media_upload_uri, token.getAccessToken()), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new InputStreamBody(is, mimeType.toString(), fileName)), new FormBodyPart("description", (ContentBody)new StringBody(description.toJSONString(), Consts.UTF_8))});
            String string = response.getAsJson().getString("media_id");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new WeixinException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public MediaCounter countMaterialMedia() throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_media_count_uri = this.getRequestUri("material_media_count_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(material_media_count_uri, token.getAccessToken()), new URLParameter[0]);
        return (MediaCounter)response.getAsObject((TypeReference)new TypeReference<MediaCounter>(){});
    }

    public MediaRecord listMaterialMedia(MediaType mediaType, Pageable pageable) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_media_list_uri = this.getRequestUri("material_media_list_uri");
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)mediaType.name());
        obj.put("offset", (Object)pageable.getOffset());
        obj.put("count", (Object)pageable.getPageSize());
        WeixinResponse response = this.weixinExecutor.post(String.format(material_media_list_uri, token.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        obj.put("items", obj.remove((Object)"item"));
        MediaRecord mediaRecord = null;
        mediaRecord = mediaType == MediaType.news ? (MediaRecord)JSON.parseObject((String)obj.toJSONString(), MediaRecord.class, (ParseProcess)new ExtraProcessor(){

            public void processExtra(Object object, String key, Object value) {
                if (key.equals("content")) {
                    ((MediaItem)object).setArticles(JSON.parseArray((String)((JSONObject)value).getString("news_item"), MpArticle.class));
                }
            }
        }, (Feature[])new Feature[0]) : (MediaRecord)JSON.toJavaObject((JSON)obj, MediaRecord.class);
        mediaRecord.setMediaType(mediaType);
        mediaRecord.setPageable(pageable);
        return mediaRecord;
    }

    public List<MediaItem> listAllMaterialMedia(MediaType mediaType) throws WeixinException {
        Pageable pageable = new Pageable(1, 20);
        ArrayList<MediaItem> mediaList = new ArrayList<MediaItem>();
        MediaRecord mediaRecord = null;
        while ((mediaRecord = this.listMaterialMedia(mediaType, pageable)).getItems() != null && !mediaRecord.getItems().isEmpty()) {
            mediaList.addAll(mediaRecord.getItems());
            if (!mediaRecord.getPagedata().hasNext()) break;
            pageable = pageable.next();
        }
        return mediaList;
    }
}

