/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.component.WeixinComponentPreCodeCreator;
import com.foxinmy.weixin4j.mp.component.WeixinComponentTokenCreator;
import com.foxinmy.weixin4j.mp.component.WeixinTokenComponentCreator;
import com.foxinmy.weixin4j.mp.model.AuthorizerOption;
import com.foxinmy.weixin4j.mp.model.ComponentAuthInfo;
import com.foxinmy.weixin4j.mp.model.OauthToken;
import com.foxinmy.weixin4j.token.PerTicketManager;
import com.foxinmy.weixin4j.token.TicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class ComponentApi
extends MpApi {
    private final TokenManager tokenManager;
    private final TicketManager ticketManager;
    private final TokenManager preCodeManager;

    public ComponentApi(TicketManager ticketManager) {
        this.ticketManager = ticketManager;
        this.tokenManager = new TokenManager((TokenCreator)new WeixinComponentTokenCreator(ticketManager), ticketManager.getCacheStorager());
        this.preCodeManager = new TokenManager((TokenCreator)new WeixinComponentPreCodeCreator(this.tokenManager, ticketManager.getThirdId()), ticketManager.getCacheStorager());
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public TicketManager getTicketManager() {
        return this.ticketManager;
    }

    public TokenManager getPreCodeManager() {
        return this.preCodeManager;
    }

    public PerTicketManager getRefreshTokenManager(String authAppId) {
        return new PerTicketManager(authAppId, this.ticketManager.getThirdId(), this.ticketManager.getThirdSecret(), this.ticketManager.getCacheStorager());
    }

    public String getUserAuthorizationURL(String authAppId) {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"component.user.oauth.redirect.uri");
        return this.getUserAuthorizationURL(authAppId, redirectUri, "snsapi_base", "state");
    }

    public String getUserAuthorizationURL(String authAppId, String redirectUri, String scope, String state) {
        String sns_component_user_auth_uri = this.getRequestUri("sns_component_user_auth_uri");
        try {
            return String.format(sns_component_user_auth_uri, authAppId, URLEncoder.encode(redirectUri, Consts.UTF_8.name()), scope, state, this.ticketManager.getThirdId());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public OauthToken getAuthorizationToken(String authAppId, String code) throws WeixinException {
        String sns_component_user_token_uri = this.getRequestUri("sns_component_user_token_uri");
        String accessToken = this.tokenManager.getAccessToken();
        WeixinResponse response = this.weixinExecutor.get(String.format(sns_component_user_token_uri, authAppId, code, this.ticketManager.getThirdId(), accessToken), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        OauthToken token = new OauthToken(result.getString("access_token"), result.getLongValue("expires_in") * 1000L);
        token.setOpenId(result.getString("openid"));
        token.setScope(result.getString("scope"));
        token.setRefreshToken(result.getString("refresh_token"));
        return token;
    }

    public OauthToken refreshAuthorizationToken(String authAppId, String refreshToken) throws WeixinException {
        String sns_component_token_refresh_uri = this.getRequestUri("sns_component_token_refresh_uri");
        String accessToken = this.tokenManager.getAccessToken();
        WeixinResponse response = this.weixinExecutor.get(String.format(sns_component_token_refresh_uri, authAppId, this.ticketManager.getThirdId(), accessToken, refreshToken), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        OauthToken token = new OauthToken(result.getString("access_token"), result.getLongValue("expires_in") * 1000L);
        token.setOpenId(result.getString("openid"));
        token.setScope(result.getString("scope"));
        token.setRefreshToken(result.getString("refresh_token"));
        return token;
    }

    public ComponentAuthInfo exchangeAuthInfo(String authCode) throws WeixinException {
        String component_exchange_authorizer_uri = this.getRequestUri("component_exchange_authorizer_uri");
        JSONObject obj = new JSONObject();
        obj.put("component_appid", (Object)this.ticketManager.getThirdId());
        obj.put("authorization_code", (Object)authCode);
        WeixinResponse response = this.weixinExecutor.post(String.format(component_exchange_authorizer_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        JSONObject authObj = obj.getJSONObject("authorization_info");
        JSONArray privilegesObj = authObj.getJSONArray("func_info");
        ArrayList<Integer> privileges = new ArrayList<Integer>(privilegesObj.size());
        for (int i = 0; i < privilegesObj.size(); ++i) {
            privileges.add(privilegesObj.getJSONObject(i).getJSONObject("funcscope_category").getInteger("id"));
        }
        ComponentAuthInfo info = new ComponentAuthInfo();
        info.setPrivileges(privileges);
        info.setAppId(authObj.getString("authorizer_appid"));
        PerTicketManager perTicketManager = this.getRefreshTokenManager(info.getAppId());
        WeixinTokenComponentCreator tokenCreator = new WeixinTokenComponentCreator(perTicketManager, this.tokenManager);
        Token token = new Token(authObj.getString("authorizer_access_token"), authObj.getLongValue("expires_in") * 1000L);
        this.ticketManager.getCacheStorager().caching(tokenCreator.key(), (Cacheable)token);
        perTicketManager.cachingTicket(authObj.getString("authorizer_refresh_token"));
        return info;
    }

    public ComponentAuthInfo getAuthInfo(String authAppId) throws WeixinException {
        String component_get_authorizer_uri = this.getRequestUri("component_get_authorizer_uri");
        JSONObject obj = new JSONObject();
        obj.put("component_appid", (Object)this.ticketManager.getThirdId());
        obj.put("authorizer_appid", (Object)authAppId);
        WeixinResponse response = this.weixinExecutor.post(String.format(component_get_authorizer_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        JSONObject auth = obj.getJSONObject("authorizer_info");
        ComponentAuthInfo info = (ComponentAuthInfo)JSON.toJavaObject((JSON)auth, ComponentAuthInfo.class);
        info.setServiceType(auth.getJSONObject("service_type_info").getIntValue("id"));
        info.setVerifyType(auth.getJSONObject("verify_type_info").getIntValue("id"));
        auth = obj.getJSONObject("authorization_info");
        JSONArray privilegesObj = auth.getJSONArray("func_info");
        ArrayList<Integer> privileges = new ArrayList<Integer>(privilegesObj.size());
        for (int i = 0; i < privilegesObj.size(); ++i) {
            privileges.add(privilegesObj.getJSONObject(i).getJSONObject("funcscope_category").getInteger("id"));
        }
        info.setPrivileges(privileges);
        info.setAppId(auth.getString("appid"));
        return info;
    }

    public AuthorizerOption getAuthorizerOption(String authAppId, AuthorizerOption.AuthorizerOptionName optionName) throws WeixinException {
        String component_get_authorizer_option_uri = this.getRequestUri("component_get_authorizer_option_uri");
        JSONObject obj = new JSONObject();
        obj.put("component_appid", (Object)this.ticketManager.getThirdId());
        obj.put("authorizer_appid", (Object)authAppId);
        obj.put("option_name", (Object)optionName.name());
        WeixinResponse response = this.weixinExecutor.post(String.format(component_get_authorizer_option_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        int optionValue = response.getAsJson().getIntValue("option_value");
        return AuthorizerOption.parse(optionName, optionValue);
    }

    public ApiResult setAuthorizerOption(String authAppId, AuthorizerOption option) throws WeixinException {
        String component_set_authorizer_option_uri = this.getRequestUri("component_set_authorizer_option_uri");
        JSONObject obj = new JSONObject();
        obj.put("component_appid", (Object)this.ticketManager.getThirdId());
        obj.put("authorizer_appid", (Object)authAppId);
        obj.put("option_name", (Object)option.getName());
        obj.put("option_value", (Object)option.getValue());
        WeixinResponse response = this.weixinExecutor.post(String.format(component_set_authorizer_option_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }
}

