/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.tuple;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.tuple.MassTuple;
import com.foxinmy.weixin4j.tuple.MpArticle;
import com.foxinmy.weixin4j.tuple.NotifyTuple;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class MpNews
implements MassTuple,
NotifyTuple {
    private static final long serialVersionUID = 8853054484809101524L;
    private static final int MAX_ARTICLE_COUNT = 8;
    @JSONField(name="media_id")
    @XmlElement(name="MediaId")
    private String mediaId;
    @XmlTransient
    private LinkedList<MpArticle> articles;

    @Override
    public String getMessageType() {
        return "mpnews";
    }

    public MpNews(String mediaId) {
        this.mediaId = mediaId;
        this.articles = new LinkedList();
    }

    public MpNews(MpArticle ... articles) {
        this.articles = new LinkedList<MpArticle>(Arrays.asList(articles));
    }

    public MpNews addArticle(String thumbMediaId, String title, String content) {
        return this.addArticle(new MpArticle(thumbMediaId, title, content));
    }

    public MpNews addArticle(MpArticle ... articles) {
        for (MpArticle article : articles) {
            this.articles.add(article);
        }
        return this;
    }

    public MpNews addFirstArticle(MpArticle article) {
        this.articles.addFirst(article);
        return this;
    }

    public MpNews addLastArticle(MpArticle article) {
        this.articles.addLast(article);
        return this;
    }

    public MpNews removeFirstArticle() {
        this.articles.removeFirst();
        return this;
    }

    public MpNews removeLastArticle() {
        this.articles.removeLast();
        return this;
    }

    @JSONField(serialize=false)
    @XmlTransient
    public boolean isMaxCount() {
        return this.articles.size() == 8;
    }

    public List<MpArticle> getArticles() {
        if (this.articles.size() > 8) {
            return this.articles.subList(0, 8);
        }
        return this.articles;
    }

    @JSONField(serialize=false)
    @XmlTransient
    public List<MpArticle> getFullArticles() {
        return this.articles;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String toString() {
        return "MpNews [articles=" + this.articles + ", mediaId=" + this.mediaId + "]";
    }
}

