/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.paging;

import com.foxinmy.weixin4j.model.paging.Pageable;
import com.foxinmy.weixin4j.model.paging.Sort;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class Pagedata<T>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = 163159826528502864L;
    private final int total;
    private final Pageable pageable;
    private final List<T> content;

    public Pagedata(Pageable pageable, int total, List<T> content) {
        this.pageable = pageable;
        this.total = total;
        this.content = content;
    }

    public int getNumber() {
        return this.pageable == null ? 0 : this.pageable.getPageNumber();
    }

    public int getSize() {
        return this.pageable == null ? 0 : this.pageable.getPageSize();
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public int getTotalElements() {
        return this.total;
    }

    public int getNumberOfElements() {
        return this.hasContent() ? 0 : this.content.size();
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public boolean hasPrevious() {
        return this.pageable == null ? false : this.pageable.hasPrevious();
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public Sort getSort() {
        return this.pageable == null ? null : this.pageable.getSort();
    }

    public List<T> getContent() {
        return this.content;
    }

    @Override
    public Iterator<T> iterator() {
        return this.hasContent() ? this.content.iterator() : null;
    }

    public String toString() {
        return "Pagedata [total=" + this.total + ", pageable=" + this.pageable + "]";
    }
}

