/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.weixin;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.HttpStatus;
import com.foxinmy.weixin4j.http.HttpVersion;
import com.foxinmy.weixin4j.http.message.JsonMessageConverter;
import com.foxinmy.weixin4j.http.message.MessageConverter;
import com.foxinmy.weixin4j.http.message.XmlMessageConverter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WeixinResponse
implements HttpResponse {
    private volatile String text;
    private final HttpResponse response;
    private static List<MessageConverter> messageConverters = new ArrayList<MessageConverter>();
    private final TypeReference<ApiResult> APIRESULT_CLAZZ = new TypeReference<ApiResult>(){};
    private final TypeReference<XmlResult> XMLRESULT_CLAZZ = new TypeReference<XmlResult>(){};
    private final TypeReference<JSONObject> JSONOBJECT_CLAZZ = new TypeReference<JSONObject>(){};

    public WeixinResponse(HttpResponse response) {
        this.response = response;
    }

    public String getAsString() {
        if (this.text == null) {
            this.text = StringUtil.newStringUtf8(this.getContent());
        }
        return this.text;
    }

    public ApiResult getAsResult() {
        return this.getAsObject(this.APIRESULT_CLAZZ);
    }

    public JSONObject getAsJson() {
        return this.getAsObject(this.JSONOBJECT_CLAZZ);
    }

    public XmlResult getAsXml() {
        return this.getAsObject(this.XMLRESULT_CLAZZ);
    }

    public <T> T getAsObject(TypeReference<T> typeReference) {
        Class clazz = (Class)typeReference.getType();
        for (MessageConverter messageConverter : messageConverters) {
            if (!messageConverter.canConvert(clazz, this.response)) continue;
            try {
                return messageConverter.convert(clazz, this.response);
            }
            catch (IOException e) {
                throw new RuntimeException("IO error on convert to " + clazz, e);
            }
        }
        if (clazz.isAssignableFrom(ApiResult.class)) {
            return (T)new ApiResult();
        }
        throw new RuntimeException("cannot convert to " + clazz);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public HttpStatus getStatus() {
        return this.response.getStatus();
    }

    @Override
    public byte[] getContent() {
        return this.response.getContent();
    }

    @Override
    public InputStream getBody() {
        return this.response.getBody();
    }

    @Override
    public HttpVersion getProtocol() {
        return this.response.getProtocol();
    }

    @Override
    public void close() {
        this.response.close();
    }

    static {
        messageConverters.add(new JsonMessageConverter());
        messageConverters.add(new XmlMessageConverter());
    }
}

