/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.weixin;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.apache.FormBodyPart;
import com.foxinmy.weixin4j.http.apache.HttpMultipartMode;
import com.foxinmy.weixin4j.http.apache.MultipartEntity;
import com.foxinmy.weixin4j.http.entity.FormUrlEntity;
import com.foxinmy.weixin4j.http.entity.StringEntity;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.message.XmlMessageConverter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.logging.InternalLogLevel;
import com.foxinmy.weixin4j.logging.InternalLogger;
import com.foxinmy.weixin4j.logging.InternalLoggerFactory;
import com.foxinmy.weixin4j.util.Consts;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class WeixinRequestExecutor {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private static final String SUCCESS_CODE = ",0,success,";
    private final HttpClient httpClient;

    public WeixinRequestExecutor() {
        this.httpClient = HttpClientFactory.getInstance();
    }

    public WeixinRequestExecutor(HttpParams params) {
        this.httpClient = HttpClientFactory.getInstance(params);
    }

    public WeixinResponse post(String url, String body) throws WeixinException {
        StringEntity entity = new StringEntity(body);
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.doRequest(request);
    }

    public WeixinResponse post(String url, FormBodyPart ... bodyParts) throws WeixinException {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Consts.UTF_8);
        for (FormBodyPart bodyPart : bodyParts) {
            entity.addPart(bodyPart);
        }
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.doRequest(request);
    }

    public WeixinResponse get(String url, URLParameter ... parameters) throws WeixinException {
        StringBuilder buf = new StringBuilder(url).append("&");
        if (parameters != null && parameters.length > 0) {
            buf.append(FormUrlEntity.formatParameters(Arrays.asList(parameters)));
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, buf.toString());
        return this.doRequest(request);
    }

    public WeixinResponse doRequest(HttpRequest request) throws WeixinException {
        try {
            if (this.logger.isEnabled(InternalLogLevel.DEBUG)) {
                this.logger.debug("weixin request >> " + (Object)((Object)request.getMethod()) + " " + request.getURI().toString());
            }
            HttpResponse httpResponse = this.httpClient.execute(request);
            WeixinResponse response = new WeixinResponse(httpResponse);
            this.handleResponse(response);
            return response;
        }
        catch (HttpClientException e) {
            throw new WeixinException(e);
        }
    }

    private boolean hasStreamMimeType(WeixinResponse response) {
        MimeType responseMimeType = MimeType.valueOf(response.getHeaders().getContentType());
        for (MimeType streamMimeType : MimeType.STREAM_MIMETYPES) {
            if (!streamMimeType.includes(responseMimeType)) continue;
            return true;
        }
        return false;
    }

    protected void handleResponse(WeixinResponse response) throws WeixinException {
        boolean hasStreamMimeType = this.hasStreamMimeType(response);
        if (this.logger.isEnabled(InternalLogLevel.DEBUG)) {
            this.logger.debug("weixin response << " + response.getProtocol() + response.getStatus() + ":" + (hasStreamMimeType ? response.getHeaders().getContentType() : response.getAsString()));
        }
        if (hasStreamMimeType) {
            return;
        }
        ApiResult result = response.getAsResult();
        if (!SUCCESS_CODE.contains(String.format(",%s,", result.getReturnCode().toLowerCase()))) {
            throw new WeixinException(result.getReturnCode(), result.getReturnMsg());
        }
        if (XmlMessageConverter.GLOBAL.canConvert(XmlResult.class, response)) {
            try {
                XmlResult xmlResult = XmlMessageConverter.GLOBAL.convert(XmlResult.class, response);
                if (!SUCCESS_CODE.contains(String.format(",%s,", xmlResult.getResultCode().toLowerCase()))) {
                    throw new WeixinException(xmlResult.getErrCode(), xmlResult.getErrCodeDes());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public HttpClient getExecuteClient() {
        return this.httpClient;
    }

    public WeixinRequestExecutor createSSLRequestExecutor(String password, InputStream inputStream) throws WeixinException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, password.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            return this.createSSLRequestExecutor(sslContext);
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            throw new WeixinException("Key load error", e);
        }
    }

    public WeixinRequestExecutor createSSLRequestExecutor(SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be empty");
        }
        HttpParams params = new HttpParams();
        params.setSSLContext(sslContext);
        return new WeixinRequestExecutor(params);
    }
}

